/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.push;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.message.DefaultJmsAttributes;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.source.JmsConnectionExceptionResolver;
import org.mule.jms.commons.internal.source.JmsListener;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.source.JmsMessageDispatcher;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageListener<T extends DefaultJmsAttributes>
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageListener.class);
    private final JmsSession session;
    private final SourceCallback<Object, T> sourceCallback;
    private final JmsListenerLock jmsLock;
    private final JmsMessageDispatcher messageDispatcher;
    private final JmsSessionManager sessionManager;
    private final JmsConnectionExceptionResolver exceptionResolver;
    private final boolean isTransactedSession;
    private ConnectionProvider<JmsTransactionalConnection> connectionProvider;
    private AtomicBoolean enabled = new AtomicBoolean(true);

    JmsMessageListener(JmsSession session, JmsConfig config, JmsListenerLock jmsLock, JmsSessionManager sessionManager, SourceCallback<Object, T> sourceCallback, JmsSpecification specification, InternalAckMode ackMode, String encoding, String contentType, ConnectionProvider<JmsTransactionalConnection> connectionProvider, JmsConnectionExceptionResolver exceptionResolver) {
        this.session = session;
        this.sourceCallback = sourceCallback;
        this.jmsLock = jmsLock;
        this.sessionManager = sessionManager;
        this.connectionProvider = connectionProvider;
        this.exceptionResolver = exceptionResolver;
        this.isTransactedSession = ackMode.equals((Object)InternalAckMode.TRANSACTED);
        this.messageDispatcher = new JmsMessageDispatcher(config, contentType, encoding, specification, () -> session, ackMode, sessionManager, sourceCallback, jmsLock, exceptionResolver);
    }

    public void onMessage(Message message) {
        if (this.enabled.get() || !this.isTransactedSession) {
            this.doOnMessage(message);
        } else {
            LOGGER.warn(this.getListenerIsBeingClosedMessage(message));
            try {
                this.session.get().rollback();
            }
            catch (JMSException e) {
                LOGGER.error("An error occurred trying to rollback the current session {}", (Object)this.session);
            }
        }
    }

    protected void doOnMessage(Message message) {
        LOGGER.debug("Received message on session [{}]", (Object)this.session.get().toString());
        this.logNewMessageIds(message);
        SourceCallbackContext context = this.sourceCallback.createContext();
        try {
            context.bindConnection(this.connectionProvider.connect());
        }
        catch (ConnectionException | TransactionException e) {
            JmsListener.notifyIfConnectionProblem(this.sourceCallback, (Exception)e, this.exceptionResolver);
        }
        if (this.isTransactedSession) {
            this.sessionManager.bindToTransaction(this.session);
        }
        this.jmsLock.init();
        context.addVariable("JMS_LOCK", (Object)this.jmsLock);
        try {
            this.messageDispatcher.dispatchMessage(message, context);
            this.waitForMessageToBeProcessed(this.jmsLock);
        }
        catch (Exception e) {
            LOGGER.warn("An error occurred processing the message, returning it to the queue", (Throwable)e);
            if (this.isTransactedSession) {
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
            this.tryRecoverSession();
        }
    }

    protected void tryRecoverSession() {
        try {
            this.session.get().recover();
        }
        catch (JMSException jmsException) {
            LOGGER.warn("An error occurred trying to recover the session because of a failure message processing.", (Throwable)jmsException);
        }
    }

    protected void logNewMessageIds(Message message) {
        try {
            LOGGER.debug("New Message: MessageID [{}]. CorrelationID [{}]", (Object)message.getJMSMessageID(), (Object)message.getJMSCorrelationID());
        }
        catch (JMSException e) {
            LOGGER.debug("New Message: Message/Correlation ID's could not be extracted because of: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void waitForMessageToBeProcessed(JmsListenerLock jmsLock) {
        LOGGER.debug("Waiting for message to be processed through flow");
        jmsLock.lock();
        LOGGER.debug("Resuming message consuming");
    }

    public void setEnabled(boolean state) {
        LOGGER.debug("Switching message listener [{}] enabled flag to [{}]", (Object)this, (Object)state);
        this.enabled.set(state);
    }

    private String getListenerIsBeingClosedMessage(Message message) {
        try {
            String jmsMessageID = message.getJMSMessageID();
            String jmsCorrelationID = message.getJMSCorrelationID();
            return String.format("Message listener is being closed, the current message with ID %S and Correlation ID %S is not going to be processed and is returned to the Queue.", jmsMessageID, jmsCorrelationID);
        }
        catch (Exception e) {
            return "Message listener is being closed, the current message is not going to be processed and is returned to the Queue.";
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }
}

