/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.polling;

import javax.jms.Destination;
import javax.jms.JMSException;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;

public class MessageConsumerFactory {
    private JmsConnection connection;
    private final String destination;
    private final JmsConfig jmsConfig;
    private final String selector;
    private final ConsumerType consumerType;

    MessageConsumerFactory(JmsConnection connection, String destination, String selector, ConsumerType consumerType, JmsConfig jmsConfig) {
        this.connection = connection;
        this.destination = destination;
        this.jmsConfig = jmsConfig;
        this.selector = selector;
        this.consumerType = consumerType;
    }

    public JmsMessageConsumer createConsumer(JmsSession session) throws JMSException {
        Destination jmsDestination = this.connection.getJmsSupport().createDestination(session.get(), this.destination, this.consumerType.topic(), this.jmsConfig);
        return this.connection.createConsumer(session, jmsDestination, this.selector, this.consumerType);
    }
}

