/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source;

import java.util.function.Supplier;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.message.JmsResultFactory;
import org.mule.jms.commons.internal.source.JmsConnectionExceptionResolver;
import org.mule.jms.commons.internal.source.JmsListener;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.source.push.JmsMessageListener;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageListener.class);
    private final String defaultEncoding;
    private final String defaultContentType;
    private final JmsSessionManager sessionManager;
    private final SourceCallback sourceCallback;
    private final JmsConnectionExceptionResolver exceptionResolver;
    static final String JMS_ACK_ID = "JMS_ACK_ID";
    private JmsConfig config;
    private JmsSpecification specification;
    private Supplier<JmsSession> session;
    private InternalAckMode ackMode;
    private JmsListenerLock jmsListenerLock;
    private JmsResultFactory resultFactory = JmsResultFactory.getInstance();

    public JmsMessageDispatcher(JmsConfig config, String defaultContentType, String defaultEncoding, JmsSpecification specification, Supplier<JmsSession> session, InternalAckMode ackMode, JmsSessionManager sessionManager, SourceCallback sourceCallback, JmsListenerLock jmsListenerLock, JmsConnectionExceptionResolver exceptionResolver) {
        this.config = config;
        this.defaultContentType = defaultContentType;
        this.defaultEncoding = defaultEncoding;
        this.specification = specification;
        this.session = session;
        this.ackMode = ackMode;
        this.sessionManager = sessionManager;
        this.sourceCallback = sourceCallback;
        this.jmsListenerLock = jmsListenerLock;
        this.exceptionResolver = exceptionResolver;
    }

    public void dispatchMessage(Message message, SourceCallbackContext context) throws Exception {
        try {
            this.saveReplyToDestination(message, context);
            context.setCorrelationId(this.getCorrelationId(message));
            Result result = this.resultFactory.createResult(message, this.specification, this.resolveContentType(message), this.resolveEncoding(message), this.session.get().getAckId());
            this.registerAckIdIfRequired(context, message);
            LOGGER.trace("Dispatching Message");
            this.sourceCallback.handle(result, context);
            this.doAckIfRequired(message);
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while dispatching a Message from the listener on session [%s]: %s", this.session.get(), e.getMessage());
            LOGGER.error(msg, (Throwable)e);
            JmsListener.notifyIfConnectionProblem(this.sourceCallback, e, this.exceptionResolver);
            throw e;
        }
    }

    private String resolveContentType(Message message) {
        return JmsCommons.resolveOverride(JmsCommons.resolveMessageContentType(message, this.config.getContentType()), this.defaultContentType);
    }

    private String resolveEncoding(Message message) {
        return JmsCommons.resolveOverride(JmsCommons.resolveMessageEncoding(message, this.config.getEncoding()), this.defaultEncoding);
    }

    private void saveReplyToDestination(Message message, SourceCallbackContext context) {
        try {
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo != null) {
                context.addVariable("REPLY_TO_DESTINATION", (Object)replyTo);
                context.addVariable("MESSAGE_ID", (Object)message.getJMSMessageID());
                context.addVariable("CORRELATION_ID", (Object)message.getJMSCorrelationID());
            }
        }
        catch (JMSException e) {
            LOGGER.error("An error occurred while obtaining the ReplyTo destination: ", (Throwable)e);
            JmsListener.notifyIfConnectionProblem(this.sourceCallback, (Exception)((Object)e), this.exceptionResolver);
        }
    }

    private void registerAckIdIfRequired(SourceCallbackContext callbackContext, Message message) {
        if (this.ackMode.equals((Object)InternalAckMode.MANUAL)) {
            LOGGER.debug("Registering pending ACK on session: " + this.session.get().getAckId());
            String id = this.session.get().getAckId().orElseThrow(() -> new IllegalArgumentException("An AckId is required when MANUAL AckMode is set"));
            callbackContext.addVariable(JMS_ACK_ID, (Object)id);
            this.sessionManager.registerMessageForAck(id, message, this.session.get().get(), this.jmsListenerLock);
        }
    }

    private void doAckIfRequired(Message message) throws JMSException {
        if (this.ackMode.equals((Object)InternalAckMode.IMMEDIATE)) {
            LOGGER.debug("Automatically performing an ACK over the message, since AckMode was IMMEDIATE");
            message.acknowledge();
        }
    }

    private String getCorrelationId(Message message) {
        try {
            return message.getJMSCorrelationID();
        }
        catch (JMSException e) {
            LOGGER.debug("Failed to obtain correlationId from message", (Throwable)e);
            return null;
        }
    }
}

