/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.lock;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.jms.commons.api.lock.JmsListenerLockFactory;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.source.DefaultJmsListenerLock;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.source.NullJmsListenerLock;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmsListenerLockFactory
implements JmsListenerLockFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJmsListenerLockFactory.class);
    private AtomicBoolean enabled = new AtomicBoolean(true);

    @Override
    public JmsListenerLock createLock(InternalAckMode resolvedAckMode) {
        Preconditions.checkState((boolean)this.enabled.get(), (String)"Cannot generate a new lock. Listener is stopped");
        if (resolvedAckMode.equals((Object)InternalAckMode.IMMEDIATE) || resolvedAckMode.equals((Object)InternalAckMode.TRANSACTED)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Session lock skipped for ACK mode [%s].", resolvedAckMode.name()));
            }
            return new NullJmsListenerLock();
        }
        return new DefaultJmsListenerLock();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }
}

