/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.session;

import java.util.Optional;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.jms.commons.internal.connection.session.JmsMessageAckedMonitor;
import org.mule.jms.commons.internal.source.JmsListenerLock;

final class SessionInformation {
    private Message message;
    private Session session;
    private JmsListenerLock jmsListenerLock;
    private final Optional<JmsMessageAckedMonitor> jmsMessageAckedMonitor;

    SessionInformation(Message message, Session session, JmsListenerLock jmsListenerLock) {
        this(message, session, jmsListenerLock, null);
    }

    SessionInformation(Message message, Session session, JmsListenerLock jmsListenerLock, JmsMessageAckedMonitor jmsMessageAckedMonitor) {
        this.message = message;
        this.session = session;
        this.jmsListenerLock = jmsListenerLock;
        this.jmsMessageAckedMonitor = Optional.ofNullable(jmsMessageAckedMonitor);
    }

    Message getMessage() {
        return this.message;
    }

    public void notifyMessageAcked() {
        this.jmsMessageAckedMonitor.ifPresent(JmsMessageAckedMonitor::notifyMessageAcked);
    }

    Session getSession() {
        return this.session;
    }

    Optional<JmsListenerLock> getJmsListenerLock() {
        return Optional.ofNullable(this.jmsListenerLock);
    }
}

