/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.JmsXaContext;
import org.mule.jms.commons.internal.connection.session.AckCallback;
import org.mule.jms.commons.internal.connection.session.JmsMessageAckedMonitor;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.SessionInformation;
import org.mule.jms.commons.internal.connection.session.TransactionInformation;
import org.mule.jms.commons.internal.connection.session.TransactionStatus;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsSessionManager.class);
    private final Map<String, SessionInformation> pendingSessions = new HashMap<String, SessionInformation>();
    private final ThreadLocal<TransactionInformation> transactionInformation = new ThreadLocal();
    private final ThreadLocal<Map<XATransactionalConnection, TransactionInformation>> xaTransactions = new ThreadLocal();

    public void registerMessageForAck(String ackId, Message message, Session session, JmsListenerLock jmsLock) {
        this.registerMessageForAck(ackId, message, session, jmsLock, null);
    }

    public void registerMessageForAck(String ackId, Message message, Session session, JmsListenerLock jmsLock, JmsMessageAckedMonitor jmsMessageAckedMonitor) {
        if (LOGGER.isTraceEnabled()) {
            try {
                LOGGER.trace("Registering message for Ack. AckId: [{}], JmsMessageId: [{}]", (Object)ackId, (Object)message.getJMSMessageID());
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while attempting to trace the JmsMessageID: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (!this.pendingSessions.containsKey(ackId)) {
            this.pendingSessions.put(ackId, new SessionInformation(message, session, jmsLock, jmsMessageAckedMonitor));
        }
        LOGGER.debug("Registered Message for Session AckId [" + ackId + "]");
    }

    public synchronized boolean isPendingAck(String ackId) {
        return this.pendingSessions.get(ackId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String ackId, AckCallback ackCallback) {
        Optional<SessionInformation> optionalSession = this.getSessionInformation(ackId);
        if (optionalSession.isPresent()) {
            Optional<JmsListenerLock> jmsListenerLock = optionalSession.get().getJmsListenerLock();
            if (jmsListenerLock.isPresent()) {
                jmsListenerLock.get().executeOnListenerThread(() -> {
                    try {
                        Message message = ((SessionInformation)optionalSession.get()).getMessage();
                        if (LOGGER.isTraceEnabled()) {
                            try {
                                LOGGER.trace("Attempting to acknowledge message with ackId: [{}], JmsMessageID:[{}]", (Object)ackId, (Object)message.getJMSMessageID());
                            }
                            catch (Exception e) {
                                LOGGER.error("Caught exception while attempting to trace the JmsMessageID: {}", (Object)e.getMessage(), (Object)e);
                            }
                        }
                        message.acknowledge();
                        ackCallback.onSuccess();
                    }
                    catch (JMSException e) {
                        ackCallback.onError(e);
                    }
                });
            } else {
                try {
                    optionalSession.get().getMessage().acknowledge();
                    ackCallback.onSuccess();
                }
                catch (JMSException e) {
                    ackCallback.onError(e);
                }
                finally {
                    this.notifyMessageAcknowledged(optionalSession);
                }
            }
            LOGGER.debug("Acknowledged Message for Session with AckId [" + ackId + "]");
        } else {
            ackCallback.onSuccess();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The session could not be acknowledged. This may be due to: \n - The session has been already acknowledged\n- The session has been recovered\n - The given 'ackId' :  [" + ackId + "] is invalid.");
            }
        }
    }

    private synchronized void notifyMessageAcknowledged(Optional<SessionInformation> optionalSession) {
        optionalSession.ifPresent(SessionInformation::notifyMessageAcked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverSession(String ackId, AckCallback ackCallback) {
        Optional<SessionInformation> optionalSession = this.getSessionInformation(ackId);
        if (optionalSession.isPresent()) {
            SessionInformation sessionInformation = optionalSession.get();
            Optional<JmsListenerLock> jmsListenerLock = sessionInformation.getJmsListenerLock();
            if (jmsListenerLock.isPresent()) {
                jmsListenerLock.get().executeOnListenerThread(() -> {
                    try {
                        ((SessionInformation)optionalSession.get()).getSession().recover();
                        ackCallback.onSuccess();
                    }
                    catch (JMSException e) {
                        ackCallback.onError(e);
                    }
                });
            } else {
                try {
                    optionalSession.get().getSession().recover();
                    ackCallback.onSuccess();
                }
                catch (JMSException e) {
                    ackCallback.onError(e);
                }
                finally {
                    this.notifyMessageAcknowledged(optionalSession);
                }
            }
            LOGGER.debug("Recovered session for AckId [ " + ackId + "]");
        } else {
            ackCallback.onSuccess();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The session could not be recovered, this could be due to: \n- The session has been already recovered\n- The all session messages has been already acknowledged\n- The given 'ackId' : [" + ackId + "] is invalid");
            }
        }
    }

    private Optional<SessionInformation> getSessionInformation(String ackId) {
        return Optional.ofNullable(this.pendingSessions.remove(ackId));
    }

    public void bindToTransaction(JmsSession session) {
        LOGGER.debug("Binding transaction to current thread...");
        LOGGER.debug("Tx to bind: session: '{}'", (Object)session);
        this.getTransactionInformation().setJmsSession(session);
    }

    public void bindToTransaction(XATransactionalConnection jmsXaTransactionalConnection, JmsSession session, JmsXaContext xaResource) {
        LOGGER.debug("Binding XA transaction to current thread...");
        LOGGER.trace("Tx to bind: connection: '{}', session: '{}', xaResource: '{}'", new Object[]{jmsXaTransactionalConnection, session, xaResource});
        TransactionInformation value = new TransactionInformation();
        value.setJmsXaContext(xaResource);
        value.setJmsSession(session);
        TransactionInformation previousTxInfo = this.onXATransactions(transactions -> transactions.put(jmsXaTransactionalConnection, value));
        if (previousTxInfo != null) {
            LOGGER.trace("Tx info for connection '{}' replaced. Old value was '{}'", (Object)jmsXaTransactionalConnection, (Object)previousTxInfo);
            xaResource.afterEnds(() -> previousTxInfo.getJmsXaContext().end());
        }
    }

    public void unbindSession() {
        LOGGER.debug("Unbinding transaction from current thread...");
        this.transactionInformation.remove();
        this.onXATransactions(transactions -> {
            if (!transactions.isEmpty()) {
                LOGGER.warn("XA connections still bound after transaction finished: {}", transactions);
            }
            return null;
        });
        this.xaTransactions.remove();
    }

    public void unbindSession(XATransactionalConnection jmsXaTransactionalConnection) {
        LOGGER.debug("Unbinding connection {} from XA transaction from current thread...", (Object)jmsXaTransactionalConnection);
        if (this.onXATransactions(transactions -> {
            transactions.remove(jmsXaTransactionalConnection);
            return transactions.isEmpty();
        }).booleanValue()) {
            this.xaTransactions.remove();
        }
    }

    public Optional<JmsSession> getTransactedSession(JmsConnection connection) {
        if (connection instanceof XATransactionalConnection) {
            return this.getXaTransactedSession((XATransactionalConnection)connection);
        }
        return Optional.ofNullable(this.getTransactionInformation().getJmsSession());
    }

    public Optional<JmsSession> getXaTransactedSession(XATransactionalConnection jmsXaTransactionalConnection) {
        return Optional.ofNullable(this.onXATransactions(transactions -> (TransactionInformation)transactions.get(jmsXaTransactionalConnection))).map(TransactionInformation::getJmsSession);
    }

    public TransactionStatus getTransactionStatus() {
        TransactionStatus transactionStatus = this.getTransactionInformation().getTransactionStatus();
        return transactionStatus != null ? transactionStatus : TransactionStatus.NONE;
    }

    public void changeTransactionStatus(TransactionStatus transactionStatus) {
        this.getTransactionInformation().setTransactionStatus(transactionStatus);
    }

    private TransactionInformation getTransactionInformation() {
        TransactionInformation transactionInformation = this.transactionInformation.get();
        if (transactionInformation == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Initializing single resource transaction information.");
            }
            transactionInformation = new TransactionInformation();
            this.transactionInformation.set(transactionInformation);
        }
        return transactionInformation;
    }

    public Optional<JmsXaContext> getJmsXaContext(JmsTransactionalConnection xaTransactionalConnection) {
        return Optional.ofNullable(this.onXATransactions(transactions -> (TransactionInformation)transactions.get(xaTransactionalConnection))).map(TransactionInformation::getJmsXaContext);
    }

    private <I> I onXATransactions(Function<Map<XATransactionalConnection, TransactionInformation>, I> function) {
        Map<XATransactionalConnection, TransactionInformation> map = this.xaTransactions.get();
        if (map == null) {
            map = new HashMap<XATransactionalConnection, TransactionInformation>();
            this.xaTransactions.set(map);
        }
        return function.apply(map);
    }

    public Set<String> getPendingAcknowledgements() {
        return this.pendingSessions.keySet();
    }
}

