/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.provider;

import java.util.concurrent.Callable;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.JmsException;

public class JmsConnectionValidationTask
implements Callable<ConnectionValidationResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnectionValidationTask.class);
    JmsConnection connection;

    public JmsConnectionValidationTask(JmsConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionValidationResult call() throws Exception {
        JmsSession session = this.connection.createSession(InternalAckMode.AUTO, false);
        try {
            session.get().createMessage();
        }
        catch (JmsException e) {
            LOGGER.error("Error validating connection ", (Throwable)e);
            ConnectionValidationResult connectionValidationResult = ConnectionValidationResult.failure((String)"Invalid connection provided: Connection could not be started.", (Exception)((Object)e));
            return connectionValidationResult;
        }
        finally {
            JmsCommons.closeQuietly(session);
        }
        return ConnectionValidationResult.success();
    }
}

