/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.connection.factory.jndi;

import java.util.Optional;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.naming.NamingException;
import org.mule.jms.commons.api.connection.LookupJndiDestination;
import org.mule.jms.commons.api.connection.factory.jndi.JndiNameResolver;
import org.mule.jms.commons.api.connection.factory.jndi.JndiNameResolverProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.DelegatingConnectionFactory;

public class JndiConnectionFactory
extends DelegatingConnectionFactory
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiConnectionFactory.class);
    @Parameter
    private String connectionFactoryJndiName;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="NEVER")
    private LookupJndiDestination lookupDestination;
    @ParameterGroup(name="Jndi Name Resolver")
    private JndiNameResolverProvider nameResolverProvider;
    private JndiNameResolver nameResolver;

    public Optional<Destination> getJndiDestination(String name) {
        try {
            LOGGER.debug(String.format("Looking up %s from JNDI", name));
            Object temp = this.lookupFromJndi(name);
            return temp instanceof Destination ? Optional.of((Destination)temp) : Optional.empty();
        }
        catch (NamingException e) {
            LOGGER.debug(String.format("Failed to look up destination [%s]: ", name), (Throwable)e);
            return Optional.empty();
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.setupNameResolver();
            Object temp = this.getJndiNameResolver().lookup(this.connectionFactoryJndiName);
            if (!(temp instanceof ConnectionFactory)) {
                throw new IllegalArgumentException("No valid ConnectionFactory was provided. Unable to initialise.");
            }
            this.setTargetConnectionFactory((ConnectionFactory)temp);
        }
        catch (NamingException e) {
            LOGGER.debug("Failed to initialise the Connection factory: ", (Throwable)e);
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.getJndiNameResolver());
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.getJndiNameResolver());
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.getJndiNameResolver(), (Logger)LOGGER);
    }

    private void setupNameResolver() throws InitialisationException {
        JndiNameResolver customJndiNameResolver = this.nameResolverProvider.getCustomJndiNameResolver();
        this.nameResolver = customJndiNameResolver != null ? customJndiNameResolver : this.nameResolverProvider.createDefaultJndiResolver();
        LifecycleUtils.initialiseIfNeeded((Object)this.nameResolver);
    }

    private Object lookupFromJndi(String jndiName) throws NamingException {
        try {
            return this.getJndiNameResolver().lookup(jndiName);
        }
        catch (NamingException e) {
            LOGGER.debug(String.format("Failed to resolve lookup for name [%s]", jndiName), (Throwable)e);
            throw e;
        }
    }

    private JndiNameResolver getJndiNameResolver() {
        return this.nameResolver;
    }

    public JMSContext createContext() {
        return null;
    }

    public JMSContext createContext(String userName, String password) {
        return null;
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return null;
    }

    public JMSContext createContext(int sessionMode) {
        return null;
    }

    public String getConnectionFactoryJndiName() {
        return this.connectionFactoryJndiName;
    }

    public LookupJndiDestination getLookupDestination() {
        return this.lookupDestination;
    }

    public JndiNameResolverProvider getNameResolverProvider() {
        return this.nameResolverProvider;
    }

    public void setConnectionFactoryJndiName(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public void setLookupDestination(LookupJndiDestination lookupDestination) {
        this.lookupDestination = lookupDestination;
    }

    public void setNameResolverProvider(JndiNameResolverProvider nameResolverProvider) {
        this.nameResolverProvider = nameResolverProvider;
    }

    public JndiNameResolver getNameResolver() {
        return this.nameResolver;
    }

    public void setNameResolver(JndiNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }
}

