/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.connection.exception.CompositeJmsExceptionListener;
import org.mule.jms.commons.internal.connection.session.DefaultJmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.publish.JmsMessageProducer;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.ConnectionFactoryUtils;

public class JmsConnection
implements Stoppable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnection.class);
    private final JmsSupport jmsSupport;
    private Connection connection;
    private final CompositeJmsExceptionListener compositeExceptionListener;
    private final JmsSessionManager jmsSessionManager;

    public JmsConnection(JmsSupport jmsSupport, Connection connection, JmsSessionManager jmsSessionManager, CompositeJmsExceptionListener exceptionListener) {
        this.jmsSupport = jmsSupport;
        this.connection = connection;
        this.jmsSessionManager = jmsSessionManager;
        this.compositeExceptionListener = exceptionListener;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    public Connection get() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public JmsSession createSession(InternalAckMode ackMode, boolean isTopic) throws JMSException {
        DefaultJmsSession wrapper;
        Session session = this.jmsSupport.createSession(this.connection, isTopic, ackMode.equals((Object)InternalAckMode.TRANSACTED), ackMode.getAckModeValue());
        if (ackMode.equals((Object)InternalAckMode.MANUAL)) {
            String ackId = RandomStringUtils.randomAlphanumeric((int)16);
            wrapper = new DefaultJmsSession(session, ackId);
        } else {
            wrapper = new DefaultJmsSession(session);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created new session: {}", (Object)session);
        }
        return wrapper;
    }

    public JmsMessageConsumer createConsumer(JmsSession session, Destination jmsDestination, String selector, ConsumerType consumerType, boolean avoidCaching) throws JMSException {
        MessageConsumer consumer = this.jmsSupport.createConsumer(this.getSession(session, avoidCaching), jmsDestination, selector, consumerType);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created new Message Consumer: {}", (Object)consumer);
        }
        return new JmsMessageConsumer(consumer);
    }

    public JmsMessageConsumer createConsumer(JmsSession session, Destination jmsDestination, String selector, ConsumerType consumerType) throws JMSException {
        return this.createConsumer(session, jmsDestination, selector, consumerType, true);
    }

    public JmsMessageProducer createProducer(JmsSession session, Destination jmsDestination, boolean isTopic) throws JMSException {
        MessageProducer producer = this.jmsSupport.createProducer(session.get(), jmsDestination, isTopic);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created new Message Producer: {}", (Object)producer);
        }
        return new JmsMessageProducer(this.jmsSupport, producer, isTopic);
    }

    public void stop() throws MuleException {
        block5: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stopping JMS Connection: " + this.connection);
            }
            try {
                this.connection.stop();
            }
            catch (IllegalStateException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignoring Connection state exception - assuming already closed: ", (Throwable)ex);
                }
            }
            catch (JMSException ex) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Could not stop JMS Connection - assuming this method has been called in a Java EE web or EJB application: ", (Throwable)ex);
            }
        }
    }

    public void dispose() {
        block5: {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing JMS Connection: " + this.connection);
                }
                this.connection.close();
            }
            catch (IllegalStateException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignoring Connection state exception - assuming already closed: ", (Throwable)ex);
                }
            }
            catch (JMSException ex) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Could not close JMS Connection : ", (Throwable)ex);
            }
        }
    }

    public void registerExceptionListener(ExceptionListener exceptionListener) {
        this.compositeExceptionListener.registerExceptionListener(exceptionListener);
    }

    public void removeExceptionListener(ExceptionListener exceptionListener) {
        this.compositeExceptionListener.removeExceptionListener(exceptionListener);
    }

    private Session getSession(JmsSession session, boolean avoidCaching) {
        Session jmsSession = session.get();
        if (avoidCaching) {
            jmsSession = ConnectionFactoryUtils.getTargetSession(session.get());
        }
        return jmsSession;
    }

    public JmsSessionManager getJmsSessionManager() {
        return this.jmsSessionManager;
    }
}

