/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.session;

/**
 * Enum to indicate the current status of a transaction over a session.
 * <ul>
 * <li>{@link TransactionStatus#NONE} means that there is no started transaction for the current {@link Thread}</li>
 * <li>{@link TransactionStatus#STARTED} means that there is a transaction being executed in the current {@link Thread}</li>
 * </ul>
 *
 * @since 1.0
 */
public enum TransactionStatus {
  NONE, STARTED
}
