/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.connection;

/**
 * A provider of a reconnection manager for each configuration.
 * 
 * @since 1.8.0
 */
public interface JmsReconnectionManagerProvider {

  /**
   * Obtains a reconnection manager for the config passed as parameter.
   * 
   * @param config a config passed as parameter
   * 
   * @return the reconnection manager
   */
  JmsReconnectionManager getReconnectionManager(final String config);
}
