/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.mule.jms.commons.internal.connection.param.GenericConnectionParameters;
import org.mule.jms.commons.internal.connection.param.XaPoolParameters;
import org.mule.jms.commons.internal.connection.provider.ConnectionFactoryDecorator;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;

public class InternalConnectionFactoryDecorator
implements ConnectionFactoryDecorator {
    private MuleContext muleContext;
    private Registry registry;
    private final Constructor<?> constructor;
    private final Method setReuseSessions;
    private final Method setUserName;
    private final Method setPassword;
    private final Method setMinPoolSize;
    private final Method setMaxPoolSize;
    private final Method setMaxIdleTime;
    private final Method setClientId;
    private final Method setExceptionListener;
    private final Method buildMethod;
    private final Method appliesTo;
    private final Method decorate;
    private final LazyValue<Collection> factoryDecorators;

    InternalConnectionFactoryDecorator(MuleContext muleContext, Registry registry) {
        this.muleContext = muleContext;
        this.registry = registry;
        try {
            Class<?> decoratorClass = Class.forName("com.mulesoft.mule.runtime.bti.api.jms.ConnectionFactoryDecorator");
            Class<?> decoratorBuilderClass = Class.forName("com.mulesoft.mule.runtime.bti.api.jms.JmsConnectionConfig$Builder");
            Class<?> jmsConfigClass = Class.forName("com.mulesoft.mule.runtime.bti.api.jms.JmsConnectionConfig");
            this.constructor = decoratorBuilderClass.getConstructor(String.class);
            this.setReuseSessions = decoratorBuilderClass.getMethod("setReuseSessions", Boolean.TYPE);
            this.setUserName = decoratorBuilderClass.getMethod("setUserName", String.class);
            this.setPassword = decoratorBuilderClass.getMethod("setPassword", String.class);
            this.setClientId = decoratorBuilderClass.getMethod("setClientId", String.class);
            this.setExceptionListener = decoratorBuilderClass.getMethod("setExceptionListener", ExceptionListener.class);
            this.buildMethod = decoratorBuilderClass.getMethod("build", new Class[0]);
            this.setMinPoolSize = this.safeGetMethod(decoratorBuilderClass, "setMinPoolSize", Integer.TYPE).orElse(null);
            this.setMaxPoolSize = this.safeGetMethod(decoratorBuilderClass, "setMaxPoolSize", Integer.TYPE).orElse(null);
            this.setMaxIdleTime = this.safeGetMethod(decoratorBuilderClass, "setMaxIdleTime", Integer.TYPE).orElse(null);
            this.appliesTo = decoratorClass.getMethod("appliesTo", ConnectionFactory.class, MuleContext.class);
            this.decorate = decoratorClass.getMethod("decorate", ConnectionFactory.class, jmsConfigClass, MuleContext.class);
            this.factoryDecorators = new LazyValue(() -> {
                try {
                    return registry.lookupAllByType(decoratorClass);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"An error occurred trying to load XA Connection Factory Decorator"), (Throwable)e);
        }
    }

    @Override
    public ConnectionFactory decorate(ConnectionFactory connectionFactory, String configName, boolean reuseSessions, GenericConnectionParameters connectionParameters, XaPoolParameters xaPoolParameters, ExceptionListener exceptionListener) {
        ConnectionFactory decoratedConnectionFactory;
        try {
            Collection decorators = (Collection)this.factoryDecorators.get();
            decoratedConnectionFactory = connectionFactory;
            if (!decorators.isEmpty()) {
                Object jmsConfigBuilder = this.constructor.newInstance(configName);
                this.setReuseSessions.invoke(jmsConfigBuilder, reuseSessions);
                this.setUserName.invoke(jmsConfigBuilder, connectionParameters.getUsername());
                this.setPassword.invoke(jmsConfigBuilder, connectionParameters.getPassword());
                this.setClientId.invoke(jmsConfigBuilder, connectionParameters.getClientId());
                this.setExceptionListener.invoke(jmsConfigBuilder, exceptionListener);
                this.configureXAPool(xaPoolParameters, jmsConfigBuilder);
                Object jmsConfig = this.buildMethod.invoke(jmsConfigBuilder, new Object[0]);
                for (Object decorator : decorators) {
                    if (!this.appliesTo(this.appliesTo, decoratedConnectionFactory, decorator)) continue;
                    decoratedConnectionFactory = this.decorate(this.decorate, decoratedConnectionFactory, jmsConfig, this.muleContext, decorator);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return decoratedConnectionFactory;
    }

    private void configureXAPool(XaPoolParameters xaPoolParameters, Object jmsConfigBuilder) throws IllegalAccessException, InvocationTargetException {
        if (this.setMinPoolSize != null) {
            this.setMinPoolSize.invoke(jmsConfigBuilder, xaPoolParameters.getMinPoolSize());
        }
        if (this.setMaxPoolSize != null) {
            this.setMaxPoolSize.invoke(jmsConfigBuilder, xaPoolParameters.getMaxPoolSize());
        }
        if (this.setMaxIdleTime != null) {
            this.setMaxIdleTime.invoke(jmsConfigBuilder, xaPoolParameters.getMaxIdleTime());
        }
    }

    private ConnectionFactory decorate(Method decorate, ConnectionFactory decoratedConnectionFactory, Object build, MuleContext muleContext, Object decorator) {
        try {
            return (ConnectionFactory)decorate.invoke(decorator, decoratedConnectionFactory, build, muleContext);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"An error occurred trying to decorate a Connection Factory."), (Throwable)e);
        }
    }

    private boolean appliesTo(Method appliesTo, ConnectionFactory decoratedConnectionFactory, Object decorator) {
        try {
            return (Boolean)appliesTo.invoke(decorator, decoratedConnectionFactory, this.muleContext);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"An error occurred trying to check if the Connection Factory can be decorated."), (Throwable)e);
        }
    }

    private Optional<Method> safeGetMethod(Class<?> targetClass, String methodName, Class<?> ... paramTypes) {
        try {
            return Optional.of(targetClass.getMethod(methodName, paramTypes));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }
}

