/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.message;

import org.mule.jms.commons.api.message.JmsAttributesBuilderFactory;
import org.mule.jms.commons.api.message.JmsHeaders;
import org.mule.jms.commons.api.message.JmsHeadersBuilder;

/**
 * {@link JmsAttributesBuilderFactory} default internal implementation.
 *
 * @since 1.0.1
 */
public class DefaultJmsAttributesBuilderFactory implements JmsAttributesBuilderFactory {

  @Override
  public DefaultJmsAttributesBuilder builder() {
    return new DefaultJmsAttributesBuilder();
  }

  @Override
  public JmsHeadersBuilder headersBuilder() {
    return new JmsHeaders.Builder();
  }
}
