/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.support;

import java.util.Optional;
import java.util.function.Function;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.connection.LookupJndiDestination;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.destination.TopicConsumer;
import org.mule.jms.commons.internal.support.Jms20Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jms11Support
extends Jms20Support {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jms11Support.class);

    public Jms11Support() {
    }

    public Jms11Support(LookupJndiDestination lookupJndiDestination, Function<String, Optional<Destination>> jndiObjectSupplier) {
        super(lookupJndiDestination, jndiObjectSupplier);
    }

    @Override
    public JmsSpecification getSpecification() {
        return JmsSpecification.JMS_1_1;
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, ConsumerType type) throws JMSException {
        if (!type.topic()) {
            LOGGER.trace("Creating Queue Consumer for [{}] with message selector [{}]", (Object)destination, (Object)messageSelector);
            return session.createConsumer(destination, messageSelector);
        }
        TopicConsumer topicConsumer = (TopicConsumer)type;
        if (topicConsumer.isDurable()) {
            LOGGER.trace("Creating durable subscriber for topic [{}], with subscription name [{}] and message selector [{}]. IsNoLocal [{}]", new Object[]{destination, topicConsumer.getSubscriptionName(), messageSelector, topicConsumer.isNoLocal()});
            return session.createDurableSubscriber((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector, topicConsumer.isNoLocal());
        }
        LOGGER.trace("Creating subscriber for topic [{}] with message selector [{}]. IsNoLocal [{}]", new Object[]{destination, messageSelector, topicConsumer.isNoLocal()});
        return session.createConsumer(destination, messageSelector, topicConsumer.isNoLocal());
    }

    @Override
    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic, CompletionListener completionListener) throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            Destination dest = producer.getDestination();
            LOGGER.debug("Sending message to [{}], persistent:[{}], with priority:[{}] and ttl:[{}]", new Object[]{dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName(), persistent, priority, ttl});
        }
        try {
            producer.send(message, persistent ? 2 : 1, priority, ttl);
            completionListener.onCompletion(message);
        }
        catch (Exception e) {
            completionListener.onException(message, e);
        }
    }
}

