/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation;

import java.util.concurrent.TimeUnit;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import org.mule.jms.commons.api.config.JmsConsumerConfig;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.exception.JmsConsumeException;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.exception.JmsSecurityException;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsMessageAckedMonitor;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.message.JmsResultFactory;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConsume
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConsume.class);
    private static final String IBM_MQRC_CONNECTION_BROKEN = "MQRC_CONNECTION_BROKEN";
    private static final String AMQ_NOT_CONNECTED_ERROR = "AMQ219010";
    private static final String LOST_SERVER_EXCEPTION = "LostServerException";
    private final JmsResultFactory resultFactory = JmsResultFactory.getInstance();
    private final Scheduler scheduler;
    private final JmsSessionManager sessionManager;

    public JmsConsume(JmsSessionManager sessionManager, SchedulerService schedulerService) {
        this.sessionManager = sessionManager;
        this.scheduler = schedulerService.ioScheduler();
    }

    public Result<Object, JmsAttributes> consume(JmsConfig config, JmsTransactionalConnection connection, String destination, ConsumerType consumerType, JmsAckMode ackMode, String selector, String contentType, String encoding, Long maximumWait, TimeUnit maximumWaitUnit, OperationTransactionalAction transactionalAction) throws JmsExtensionException, ConnectionException {
        InternalAckMode resolvedAckMode = this.resolveAck((JmsConsumerConfig)config.getConsumerConfig(), ackMode);
        Result result = null;
        JmsSession session = null;
        boolean partOfCurrentTx = false;
        JmsMessageConsumer consumer = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [consume] on the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            JmsSupport jmsSupport = connection.getJmsSupport();
            session = JmsCommons.createJmsSession(connection, resolvedAckMode, consumerType.topic(), this.sessionManager, transactionalAction);
            partOfCurrentTx = JmsCommons.isPartOfCurrentTx(session, connection, this.sessionManager);
            Destination jmsDestination = jmsSupport.createDestination(session.get(), destination, consumerType.topic(), config);
            consumer = connection.createConsumer(session, jmsDestination, selector, consumerType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consuming Message from the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            JmsSession finalSession = session;
            boolean finalPartOfCurrentTx = partOfCurrentTx;
            JmsMessageConsumer finalConsumer = consumer;
            JmsMessageAckedMonitor jmsMessageAckedMonitor = new JmsMessageAckedMonitor();
            Message message = consumer.consume(maximumWaitUnit.toMillis(maximumWait));
            if (message == null) {
                result = this.resultFactory.createEmptyResult();
            } else {
                String resolvedContentType = JmsCommons.resolveOverride(JmsCommons.resolveMessageContentType(message, config.getContentType()), contentType);
                String resolvedEncoding = JmsCommons.resolveOverride(JmsCommons.resolveMessageEncoding(message, config.getEncoding()), encoding);
                result = this.resultFactory.createResult(message, jmsSupport.getSpecification(), resolvedContentType, resolvedEncoding, session.getAckId());
                JmsCommons.evaluateMessageAck(resolvedAckMode, session, message, this.sessionManager, null, jmsMessageAckedMonitor);
            }
            if (JmsCommons.isManualAck(finalSession) && this.sessionManager.isPendingAck(finalSession.getAckId().get())) {
                config.getResourceReleaserScheduler().execute(() -> {
                    jmsMessageAckedMonitor.waitForMessageAcked();
                    JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                });
            } else {
                JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
            }
        }
        catch (JMSSecurityException e) {
            String msg = String.format("A security error occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            throw new JmsSecurityException(msg, (Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            boolean isConnectionError = session == null;
            String msg = String.format((isConnectionError ? "A connection error" : "An error") + " occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            if (e.getMessage().contains(IBM_MQRC_CONNECTION_BROKEN)) {
                isConnectionError = true;
            }
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            if (isConnectionError) {
                throw new ConnectionException((Throwable)e);
            }
            throw new JmsConsumeException(msg, (Exception)((Object)e));
        }
        catch (JmsConsumeException e) {
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            throw e;
        }
        catch (JMSException e) {
            boolean isConnectionError = false;
            if (e.getMessage() != null && e.getMessage().contains(AMQ_NOT_CONNECTED_ERROR)) {
                isConnectionError = true;
            } else if (e.getCause() != null && e.getCause().getClass().getName().contains(LOST_SERVER_EXCEPTION)) {
                isConnectionError = true;
            }
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            if (isConnectionError) {
                String msg = String.format("A connection error occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
                throw new ConnectionException(msg, (Throwable)e);
            }
            String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            throw new JmsConsumeException(msg, (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            throw new JmsConsumeException(msg, e);
        }
        return result;
    }

    public void consume(final JmsConfig config, JmsTransactionalConnection connection, final String destination, final ConsumerType consumerType, JmsAckMode ackMode, String selector, final String contentType, final String encoding, Long maximumWait, TimeUnit maximumWaitUnit, OperationTransactionalAction transactionalAction, final CompletionCallback<Object, JmsAttributes> completionCallback) throws JmsExtensionException {
        final InternalAckMode resolvedAckMode = this.resolveAck((JmsConsumerConfig)config.getConsumerConfig(), ackMode);
        JmsSession session = null;
        boolean partOfCurrentTx = false;
        JmsMessageConsumer consumer = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [consume] on the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            final JmsSupport jmsSupport = connection.getJmsSupport();
            session = JmsCommons.createJmsSession(connection, resolvedAckMode, consumerType.topic(), this.sessionManager, transactionalAction);
            partOfCurrentTx = JmsCommons.isPartOfCurrentTx(session, connection, this.sessionManager);
            Destination jmsDestination = jmsSupport.createDestination(session.get(), destination, consumerType.topic(), config);
            consumer = connection.createConsumer(session, jmsDestination, selector, consumerType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consuming Message from the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            final JmsMessageConsumer finalConsumer = consumer;
            final JmsSession finalSession = session;
            final boolean finalPartOfCurrentTx = partOfCurrentTx;
            consumer.consume(maximumWaitUnit.toMillis(maximumWait), new CompletionListener(){
                final JmsMessageAckedMonitor jmsMessageAckedMonitor = new JmsMessageAckedMonitor();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCompletion(Message received) {
                    block11: {
                        try {
                            if (received == null) {
                                completionCallback.success(JmsConsume.this.resultFactory.createEmptyResult());
                                break block11;
                            }
                            String resolvedContentType = JmsCommons.resolveOverride(JmsCommons.resolveMessageContentType(received, config.getContentType()), contentType);
                            String resolvedEncoding = JmsCommons.resolveOverride(JmsCommons.resolveMessageEncoding(received, config.getEncoding()), encoding);
                            Result result = JmsConsume.this.resultFactory.createResult(received, jmsSupport.getSpecification(), resolvedContentType, resolvedEncoding, finalSession.getAckId());
                            JmsCommons.evaluateMessageAck(resolvedAckMode, finalSession, received, JmsConsume.this.sessionManager, null, this.jmsMessageAckedMonitor);
                            completionCallback.success(result);
                        }
                        catch (Exception e) {
                            try {
                                String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
                                completionCallback.error((Throwable)((Object)new JmsConsumeException(msg, e)));
                            }
                            catch (Throwable throwable) {
                                if (JmsCommons.isManualAck(finalSession) && JmsConsume.this.sessionManager.isPendingAck(finalSession.getAckId().get())) {
                                    config.getResourceReleaserScheduler().execute(() -> {
                                        this.jmsMessageAckedMonitor.waitForMessageAcked();
                                        JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                                    });
                                } else {
                                    JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                                }
                                throw throwable;
                            }
                            if (JmsCommons.isManualAck(finalSession) && JmsConsume.this.sessionManager.isPendingAck(finalSession.getAckId().get())) {
                                config.getResourceReleaserScheduler().execute(() -> {
                                    this.jmsMessageAckedMonitor.waitForMessageAcked();
                                    JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                                });
                            } else {
                                JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                            }
                        }
                    }
                    if (JmsCommons.isManualAck(finalSession) && JmsConsume.this.sessionManager.isPendingAck(finalSession.getAckId().get())) {
                        config.getResourceReleaserScheduler().execute(() -> {
                            this.jmsMessageAckedMonitor.waitForMessageAcked();
                            JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                        });
                    } else {
                        JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                    }
                }

                public void onException(Message message, Exception e) {
                    JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                    if (e instanceof JMSSecurityException) {
                        String msg = String.format("A security error occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
                        completionCallback.error((Throwable)((Object)new JmsSecurityException(msg, e)));
                    } else if (e instanceof JmsConsumeException) {
                        completionCallback.error((Throwable)e);
                    } else if (e instanceof IllegalStateException) {
                        if (e.getMessage().contains(JmsConsume.IBM_MQRC_CONNECTION_BROKEN)) {
                            completionCallback.error((Throwable)new ConnectionException((Throwable)e));
                        } else {
                            completionCallback.error((Throwable)e);
                        }
                    } else {
                        String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
                        completionCallback.error((Throwable)((Object)new JmsConsumeException(msg, e)));
                    }
                }
            });
        }
        catch (JMSSecurityException e) {
            String msg = String.format("A security error occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            completionCallback.error((Throwable)((Object)new JmsSecurityException(msg, (Exception)((Object)e))));
        }
        catch (IllegalStateException e) {
            boolean isConnectionError = session == null;
            String msg = String.format((isConnectionError ? "A connection error" : "An error") + " occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            if (e.getMessage().contains(IBM_MQRC_CONNECTION_BROKEN)) {
                isConnectionError = true;
            }
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            completionCallback.error((Throwable)(isConnectionError ? new ConnectionException((Throwable)e) : new JmsConsumeException(msg, (Exception)((Object)e))));
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            completionCallback.error((Throwable)((Object)new JmsConsumeException(msg, e)));
        }
    }

    private InternalAckMode resolveAck(JmsConsumerConfig config, JmsAckMode ackMode) {
        InternalAckMode fallbackAck = JmsCommons.toInternalAckMode(config.getAckMode());
        if (InternalAckMode.AUTO.equals((Object)fallbackAck) || InternalAckMode.DUPS_OK.equals((Object)fallbackAck)) {
            fallbackAck = InternalAckMode.IMMEDIATE;
        }
        return JmsCommons.resolveOverride(fallbackAck, JmsCommons.toInternalAckMode(ackMode));
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }
}

