/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.message;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.destination.DefaultJmsDestination;
import org.mule.jms.commons.api.destination.DestinationType;
import org.mule.jms.commons.api.destination.JmsDestination;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.api.message.JmsAttributesBuilderFactory;
import org.mule.jms.commons.api.message.JmsHeaders;
import org.mule.jms.commons.api.message.JmsHeadersBuilder;
import org.mule.jms.commons.internal.message.DefaultJmsAttributesBuilderFactory;
import org.mule.jms.commons.internal.message.JmsAttributesBuilder;
import org.mule.jms.commons.internal.message.JmsMessageUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsResultFactory<T extends JmsAttributes> {
    private static JmsResultFactory instance = null;
    private JmsAttributesBuilderFactory builderFactory;
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsResultFactory.class);

    private JmsResultFactory(JmsAttributesBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    public static JmsResultFactory getInstance() {
        if (instance == null) {
            ServiceLoader<JmsAttributesBuilderFactory> loader = ServiceLoader.load(JmsAttributesBuilderFactory.class);
            JmsAttributesBuilderFactory builderFactory = loader.iterator().hasNext() ? loader.iterator().next() : new DefaultJmsAttributesBuilderFactory();
            instance = new JmsResultFactory(builderFactory);
        }
        return instance;
    }

    public Result<Object, T> createResult(Message jmsMessage, JmsSpecification specification, String contentType, String encoding, Optional<String> ackId) throws IOException, JMSException {
        if (jmsMessage == null) {
            LOGGER.debug("Resulting JMS Message was [null], creating an empty result");
            return this.createEmptyResult();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Creating Result: specification:[%s], type:[%s], contentType:[%s], encoding:[%s]", specification.getName(), jmsMessage.getClass().getSimpleName(), contentType, encoding));
        }
        Object payload = this.getPayload(jmsMessage, specification, encoding);
        JmsHeaders jmsHeaders = this.createJmsHeaders(jmsMessage, specification);
        return Result.builder().output(payload).mediaType(this.getMediaType(contentType, encoding)).attributes(this.createJmsAttributes(jmsHeaders, this.createJmsProperties(jmsMessage), ackId)).attributesMediaType(MediaType.APPLICATION_JAVA).build();
    }

    public Result<Object, T> createEmptyResult() {
        return Result.builder().output(null).build();
    }

    private T createJmsAttributes(JmsHeaders jmsHeaders, Map<String, Object> jmsProperties, Optional<String> ackId) {
        JmsAttributesBuilder builder = this.builderFactory.builder();
        builder.withHeaders(jmsHeaders).withProperties(jmsProperties);
        ackId.ifPresent(builder::withAckId);
        return (T)builder.build();
    }

    private Map<String, Object> createJmsProperties(Message message) {
        return JmsMessageUtils.getPropertiesMap(message);
    }

    private MediaType getMediaType(String contentType, String encoding) {
        DataTypeParamsBuilder builder = DataType.builder().mediaType(contentType);
        if (encoding != null) {
            builder.charset(Charset.forName(encoding));
        }
        return builder.build().getMediaType();
    }

    private Object getPayload(Message message, JmsSpecification specification, String encoding) throws IOException, JMSException {
        if (message == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Message type received is: " + message.getClass().getSimpleName());
        }
        return JmsMessageUtils.toObject(message, specification, encoding);
    }

    private JmsHeaders createJmsHeaders(Message jmsMessage, JmsSpecification specification) {
        JmsHeadersBuilder headersBuilder = this.builderFactory.headersBuilder();
        this.addCorrelationProperties(jmsMessage, headersBuilder);
        this.addDeliveryModeProperty(jmsMessage, headersBuilder);
        this.addDestinationProperty(jmsMessage, headersBuilder);
        this.addExpirationProperty(jmsMessage, headersBuilder);
        this.addMessageIdProperty(jmsMessage, headersBuilder);
        this.addPriorityProperty(jmsMessage, headersBuilder);
        this.addRedeliveredProperty(jmsMessage, headersBuilder);
        this.addJMSReplyTo(jmsMessage, headersBuilder);
        this.addTimestampProperty(jmsMessage, headersBuilder);
        this.addTypeProperty(jmsMessage, headersBuilder);
        if (specification.equals((Object)JmsSpecification.JMS_2_0)) {
            this.addDeliveryTimeProperty(jmsMessage, headersBuilder);
        }
        return headersBuilder.build();
    }

    private void addDeliveryTimeProperty(Message jmsMessage, JmsHeadersBuilder headersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSDeliveryTime(), value -> headersBuilder.setDeliveryTime((Long)value), "An error occurred while retrieving the JMSDeliveryTime property");
    }

    private void addTypeProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSType(), value -> jmsHeadersBuilder.setType((String)value), "An error occurred while retrieving the JMSType property");
    }

    private void addTimestampProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSTimestamp(), value -> jmsHeadersBuilder.setTimestamp((Long)value), "An error occurred while retrieving the JMSTimestamp property");
    }

    private void addJMSReplyTo(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSReplyTo(), value -> jmsHeadersBuilder.setReplyTo(this.getDestination((Destination)value)), "An error occurred while retrieving the JMSReplyTo property");
    }

    private void addRedeliveredProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSRedelivered(), value -> jmsHeadersBuilder.setRedelivered((Boolean)value), "An error occurred while retrieving the JMSRedelivered property");
    }

    private void addPriorityProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSPriority(), value -> jmsHeadersBuilder.setPriority((Integer)value), "An error occurred while retrieving the JMSPriority property");
    }

    private void addMessageIdProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSMessageID(), value -> jmsHeadersBuilder.setMessageId((String)value), "An error occurred while retrieving the JMSMessageID property");
    }

    private void addExpirationProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSExpiration(), value -> jmsHeadersBuilder.setExpiration((Long)value), "An error occurred while retrieving the JMSExpiration property");
    }

    private void addDestinationProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSDestination(), value -> jmsHeadersBuilder.setDestination(this.getDestination((Destination)value)), "An error occurred while retrieving the JMSDestination property");
    }

    private void addDeliveryModeProperty(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSDeliveryMode(), value -> jmsHeadersBuilder.setDeliveryMode((Integer)value), "An error occurred while retrieving the JMSDeliveryMode property");
    }

    private void addCorrelationProperties(Message jmsMessage, JmsHeadersBuilder jmsHeadersBuilder) {
        this.addHeader(() -> ((Message)jmsMessage).getJMSCorrelationID(), value -> jmsHeadersBuilder.setCorrelationId((String)value), "An error occurred while retrieving the JMSCorrelationID property");
    }

    private void addHeader(JmsHeaderValueSupplier valueSupplier, JmsHeaderValueConsumer headerSetter, String message) {
        block3: {
            try {
                Object value = valueSupplier.get();
                if (value != null) {
                    headerSetter.set(value);
                }
            }
            catch (JMSException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(message, (Object)e.getMessage());
            }
        }
    }

    private JmsDestination getDestination(Destination value) throws JMSException {
        DefaultJmsDestination jmsDestination = null;
        if (value instanceof Queue) {
            jmsDestination = new DefaultJmsDestination(((Queue)value).getQueueName(), DestinationType.QUEUE);
        } else if (value instanceof Topic) {
            jmsDestination = new DefaultJmsDestination(((Topic)value).getTopicName(), DestinationType.TOPIC);
        }
        return jmsDestination;
    }

    private static interface JmsHeaderValueConsumer<T> {
        public void set(T var1) throws JMSException;
    }

    private static interface JmsHeaderValueSupplier<T> {
        public T get() throws JMSException;
    }
}

