/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.operation;

import javax.jms.JMSException;
import javax.jms.Message;

import org.mule.jms.commons.api.RequestReplyPattern;
import org.mule.jms.commons.api.RequestReplyPatternWrapper;

/**
 * Default Request Reply Pattern which simply creates the selector according to the request reply pattern
 */
public class DefaultRequestReplyPatternWrapper implements RequestReplyPatternWrapper {

  public String createSelector(RequestReplyPattern requestReplyPattern, Message message) throws JMSException {
    return requestReplyPattern.createSelector(message);
  }

}
