/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.message;

import org.mule.jms.commons.api.destination.JmsDestination;

/**
 * Builder Pattern Template for {@link JmsHeaders}
 *
 * @since 1.0.1
 */
public interface JmsHeadersBuilder {

  JmsHeadersBuilder setMessageId(String messageId);

  JmsHeadersBuilder setTimestamp(long timestamp);

  JmsHeadersBuilder setCorrelationId(String correlationId);

  JmsHeadersBuilder setReplyTo(JmsDestination replyTo);

  JmsHeadersBuilder setDestination(JmsDestination destination);

  JmsHeadersBuilder setDeliveryMode(int deliveryMode);

  JmsHeadersBuilder setRedelivered(boolean redelivered);

  JmsHeadersBuilder setType(String type);

  JmsHeadersBuilder setExpiration(long expiration);

  JmsHeadersBuilder setPriority(int priority);

  JmsHeadersBuilder setDeliveryTime(long deliveryTime);

  JmsHeaders build();
}
