/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import org.mule.db.commons.internal.domain.query.BulkQuery;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.parser.QueryTemplateParser;
import org.mule.db.commons.internal.resolver.query.QueryResolutionException;

public abstract class BulkQueryFactory {
    private static final String BULK_QUERY_SEPARATOR = ";[\\r\\n]+";
    private final QueryTemplateParser parser;

    protected BulkQueryFactory(QueryTemplateParser queryTemplateParser) {
        this.parser = queryTemplateParser;
    }

    public BulkQuery resolve() {
        BulkQuery bulkQuery = this.createBulkQuery();
        if (bulkQuery.getQueryTemplates().isEmpty()) {
            throw new QueryResolutionException("There are no queries on the resolved query script: " + this.toString());
        }
        return bulkQuery;
    }

    protected abstract String resolveBulkQueries();

    protected BulkQuery createBulkQuery() {
        String[] splitQueries;
        String queries = this.resolveBulkQueries();
        BulkQuery bulkQuery = new BulkQuery();
        for (String sql : splitQueries = queries.split(BULK_QUERY_SEPARATOR)) {
            if ("".equals(sql.trim())) continue;
            QueryTemplate queryTemplate = this.parser.parse(sql);
            bulkQuery.add(queryTemplate);
        }
        return bulkQuery;
    }
}

