/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.AbstractMapStatementResultHandler;
import org.mule.db.commons.internal.result.statement.CloseableMap;
import org.mule.db.commons.internal.result.statement.StreamingStatementResultHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class StreamingStatementResultHandlerTestCase
extends AbstractMuleTestCase {
    private StreamingStatementResultHandler handler;
    private ResultSetHandler mockResultSetHandler;

    @Before
    public void setUp() {
        this.mockResultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        this.handler = new StreamingStatementResultHandler(this.mockResultSetHandler);
    }

    @Test
    public void testConstructor() {
        MatcherAssert.assertThat((Object)this.handler, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)(this.handler instanceof StreamingStatementResultHandler), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCreateResultMapReturnsCloseableMap() {
        Map resultMap = this.handler.createResultMap();
        MatcherAssert.assertThat((Object)resultMap, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)(resultMap instanceof CloseableMap), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassExtendsAbstractMapStatementResultHandler() {
        MatcherAssert.assertThat((Object)(this.handler instanceof AbstractMapStatementResultHandler), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.handler.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.result.statement"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.handler.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"StreamingStatementResultHandler"));
    }

    @Test
    public void testCreateResultMapReturnsNewInstance() {
        Map resultMap1 = this.handler.createResultMap();
        Map resultMap2 = this.handler.createResultMap();
        MatcherAssert.assertThat((Object)resultMap1, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)resultMap2, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)(resultMap1 != resultMap2 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }
}

