/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import java.sql.ResultSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.result.statement.ResultSetResult;
import org.mule.db.commons.internal.result.statement.SingleStatementResult;

@RunWith(value=MockitoJUnitRunner.class)
public class ResultSetResultTestCase {
    @Mock
    private ResultSet mockResultSet;

    @Test
    public void testConstructor() {
        String name = "testResult";
        ResultSet resultSet = this.mockResultSet;
        ResultSetResult result = new ResultSetResult(name, (Object)resultSet);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetName() {
        String name = "testResult";
        ResultSetResult result = new ResultSetResult(name, (Object)this.mockResultSet);
        String resultName = result.getName();
        Assert.assertEquals((Object)name, (Object)resultName);
    }

    @Test
    public void testGetResult() {
        ResultSet resultSet = this.mockResultSet;
        ResultSetResult result = new ResultSetResult("testResult", (Object)resultSet);
        Object resultValue = result.getResult();
        Assert.assertEquals((Object)resultSet, (Object)resultValue);
    }

    @Test
    public void testGetNameWithNullName() {
        ResultSetResult result = new ResultSetResult(null, (Object)this.mockResultSet);
        String resultName = result.getName();
        Assert.assertNull((Object)resultName);
    }

    @Test
    public void testGetResultWithNullResultSet() {
        ResultSetResult result = new ResultSetResult("testResult", null);
        Object resultValue = result.getResult();
        Assert.assertNull((Object)resultValue);
    }

    @Test
    public void testGetNameWithEmptyString() {
        String name = "";
        ResultSetResult result = new ResultSetResult(name, (Object)this.mockResultSet);
        String resultName = result.getName();
        Assert.assertEquals((Object)name, (Object)resultName);
    }

    @Test
    public void testGetNameWithSpecialCharacters() {
        String name = "result_with_underscores_and-dashes";
        ResultSetResult result = new ResultSetResult(name, (Object)this.mockResultSet);
        String resultName = result.getName();
        Assert.assertEquals((Object)name, (Object)resultName);
    }

    @Test
    public void testGetNameWithUnicodeCharacters() {
        String name = "r\u00e9sult\u00e9_\u00f1ame";
        ResultSetResult result = new ResultSetResult(name, (Object)this.mockResultSet);
        String resultName = result.getName();
        Assert.assertEquals((Object)name, (Object)resultName);
    }

    @Test
    public void testGetResultWithDifferentObjectTypes() {
        Object customObject = new Object();
        ResultSetResult result = new ResultSetResult("testResult", customObject);
        Object resultValue = result.getResult();
        Assert.assertEquals((Object)customObject, (Object)resultValue);
    }

    @Test
    public void testGetResultWithString() {
        String stringResult = "test string result";
        ResultSetResult result = new ResultSetResult("testResult", (Object)stringResult);
        Object resultValue = result.getResult();
        Assert.assertEquals((Object)stringResult, (Object)resultValue);
    }

    @Test
    public void testGetResultWithInteger() {
        Integer intResult = 42;
        ResultSetResult result = new ResultSetResult("testResult", (Object)intResult);
        Object resultValue = result.getResult();
        Assert.assertEquals((Object)intResult, (Object)resultValue);
    }

    @Test
    public void testGetResultWithBoolean() {
        Boolean boolResult = true;
        ResultSetResult result = new ResultSetResult("testResult", (Object)boolResult);
        Object resultValue = result.getResult();
        Assert.assertEquals((Object)boolResult, (Object)resultValue);
    }

    @Test
    public void testMultipleInstancesWithDifferentNames() {
        ResultSetResult result1 = new ResultSetResult("result1", (Object)this.mockResultSet);
        ResultSetResult result2 = new ResultSetResult("result2", (Object)this.mockResultSet);
        Assert.assertEquals((Object)"result1", (Object)result1.getName());
        Assert.assertEquals((Object)"result2", (Object)result2.getName());
        Assert.assertEquals((Object)this.mockResultSet, (Object)result1.getResult());
        Assert.assertEquals((Object)this.mockResultSet, (Object)result2.getResult());
    }

    @Test
    public void testMultipleInstancesWithDifferentResults() {
        Object result1 = new Object();
        Object result2 = new Object();
        ResultSetResult rsResult1 = new ResultSetResult("testResult", result1);
        ResultSetResult rsResult2 = new ResultSetResult("testResult", result2);
        Assert.assertEquals((Object)"testResult", (Object)rsResult1.getName());
        Assert.assertEquals((Object)"testResult", (Object)rsResult2.getName());
        Assert.assertEquals((Object)result1, (Object)rsResult1.getResult());
        Assert.assertEquals((Object)result2, (Object)rsResult2.getResult());
    }

    @Test
    public void testImplementsSingleStatementResult() {
        ResultSetResult result = new ResultSetResult("testResult", (Object)this.mockResultSet);
        Assert.assertTrue((boolean)(result instanceof SingleStatementResult));
    }

    @Test
    public void testGetNameReturnsSameInstance() {
        ResultSetResult result = new ResultSetResult("testResult", (Object)this.mockResultSet);
        String name1 = result.getName();
        String name2 = result.getName();
        Assert.assertSame((Object)name1, (Object)name2);
    }

    @Test
    public void testGetResultReturnsSameInstance() {
        ResultSetResult result = new ResultSetResult("testResult", (Object)this.mockResultSet);
        Object result1 = result.getResult();
        Object result2 = result.getResult();
        Assert.assertSame((Object)result1, (Object)result2);
    }
}

