/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.result.statement.OutputParamResult;
import org.mule.db.commons.internal.result.statement.SingleStatementResult;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class OutputParamResultTestCase
extends AbstractMuleTestCase {
    @Test
    public void testConstructorWithValidParameters() {
        String name = "testOutput";
        String value = "testValue";
        OutputParamResult result = new OutputParamResult(name, (Object)value);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void testConstructorWithNullName() {
        String value = "testValue";
        OutputParamResult result = new OutputParamResult(null, (Object)value);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)null));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void testConstructorWithNullValue() {
        String name = "testOutput";
        OutputParamResult result = new OutputParamResult(name, null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is(null));
    }

    @Test
    public void testConstructorWithBothNull() {
        OutputParamResult result = new OutputParamResult(null, null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)null));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is(null));
    }

    @Test
    public void testConstructorWithIntegerValue() {
        String name = "intOutput";
        Integer value = 42;
        OutputParamResult result = new OutputParamResult(name, (Object)value);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void testConstructorWithBooleanValue() {
        String name = "boolOutput";
        Boolean value = true;
        OutputParamResult result = new OutputParamResult(name, (Object)value);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void testConstructorWithEmptyStringName() {
        String name = "";
        String value = "testValue";
        OutputParamResult result = new OutputParamResult(name, (Object)value);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void testClassImplementsSingleStatementResult() {
        OutputParamResult result = new OutputParamResult("test", (Object)"value");
        MatcherAssert.assertThat((Object)(result instanceof SingleStatementResult), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        OutputParamResult result = new OutputParamResult("test", (Object)"value");
        MatcherAssert.assertThat((Object)result.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.result.statement"));
    }

    @Test
    public void testClassHasCorrectName() {
        OutputParamResult result = new OutputParamResult("test", (Object)"value");
        MatcherAssert.assertThat((Object)result.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"OutputParamResult"));
    }

    @Test
    public void testGetResultReturnsObject() {
        Object value = new Object();
        OutputParamResult result = new OutputParamResult("test", value);
        Object resultValue = result.getResult();
        MatcherAssert.assertThat((Object)resultValue, (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void testGetNameReturnsString() {
        String name = "testName";
        OutputParamResult result = new OutputParamResult(name, (Object)"value");
        String resultName = result.getName();
        MatcherAssert.assertThat((Object)(resultName instanceof String), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)resultName, (Matcher)CoreMatchers.is((Object)name));
    }
}

