/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.StatementStreamingResultSetCloser;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.resultset.IteratorResultSetHandler;
import org.mule.db.commons.internal.result.resultset.ResultSetIterator;
import org.mule.db.commons.internal.result.row.RowHandler;

@RunWith(value=MockitoJUnitRunner.class)
public class IteratorResultSetHandlerTestCase {
    @Mock
    private RowHandler mockRowHandler;
    @Mock
    private StatementStreamingResultSetCloser mockStreamingResultSetCloser;
    @Mock
    private DbConnection mockDbConnection;
    @Mock
    private ResultSet mockResultSet;
    private IteratorResultSetHandler iteratorResultSetHandler;

    @Before
    public void setUp() {
        this.iteratorResultSetHandler = new IteratorResultSetHandler(this.mockRowHandler, this.mockStreamingResultSetCloser);
    }

    @Test
    public void testConstructorWithDefaultCharset() {
        Assert.assertNotNull((Object)this.iteratorResultSetHandler);
    }

    @Test
    public void testConstructorWithCustomCharset() {
        Charset customCharset = StandardCharsets.UTF_8;
        IteratorResultSetHandler handler = new IteratorResultSetHandler(this.mockRowHandler, this.mockStreamingResultSetCloser, customCharset);
        Assert.assertNotNull((Object)handler);
        Assert.assertEquals((Object)customCharset, (Object)handler.getCharset());
    }

    @Test
    public void testProcessResultSet() throws SQLException {
        ResultSetIterator result = this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        Assert.assertNotNull((Object)result);
        ((StatementStreamingResultSetCloser)Mockito.verify((Object)this.mockStreamingResultSetCloser)).trackResultSet(this.mockResultSet);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).beginStreaming();
    }

    @Test
    public void testProcessResultSetWithNullConnection() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.iteratorResultSetHandler.processResultSet(null, this.mockResultSet));
    }

    @Test
    public void testProcessResultSetWithNullResultSet() throws SQLException {
        ResultSetIterator result = this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, null);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testProcessResultSetWithBothNull() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.iteratorResultSetHandler.processResultSet(null, null));
    }

    @Test
    public void testRequiresMultipleOpenedResults() {
        boolean result = this.iteratorResultSetHandler.requiresMultipleOpenedResults();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testGetCharset() {
        Charset result = this.iteratorResultSetHandler.getCharset();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)Charset.defaultCharset(), (Object)result);
    }

    @Test
    public void testGetCharsetWithCustomCharset() {
        Charset customCharset = StandardCharsets.UTF_16;
        IteratorResultSetHandler handler = new IteratorResultSetHandler(this.mockRowHandler, this.mockStreamingResultSetCloser, customCharset);
        Charset result = handler.getCharset();
        Assert.assertEquals((Object)customCharset, (Object)result);
    }

    @Test
    public void testProcessResultSetCreatesResultSetIterator() throws SQLException {
        ResultSetIterator result = this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ResultSetIterator));
    }

    @Test
    public void testProcessResultSetTracksResultSet() throws SQLException {
        this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        ((StatementStreamingResultSetCloser)Mockito.verify((Object)this.mockStreamingResultSetCloser)).trackResultSet(this.mockResultSet);
    }

    @Test
    public void testProcessResultSetBeginsStreaming() throws SQLException {
        this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).beginStreaming();
    }

    @Test
    public void testProcessResultSetWithSQLException() throws SQLException {
        ResultSetIterator result = this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testProcessResultSetWithConnectionException() throws SQLException {
        RuntimeException connectionException = new RuntimeException("Connection error");
        ((DbConnection)Mockito.doThrow((Throwable[])new Throwable[]{connectionException}).when((Object)this.mockDbConnection)).beginStreaming();
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet));
        Assert.assertEquals((Object)connectionException, (Object)exception);
    }

    @Test
    public void testMultipleCallsReturnSameResult() throws SQLException {
        boolean result1 = this.iteratorResultSetHandler.requiresMultipleOpenedResults();
        boolean result2 = this.iteratorResultSetHandler.requiresMultipleOpenedResults();
        boolean result3 = this.iteratorResultSetHandler.requiresMultipleOpenedResults();
        Assert.assertTrue((boolean)result1);
        Assert.assertTrue((boolean)result2);
        Assert.assertTrue((boolean)result3);
    }

    @Test
    public void testGetCharsetReturnsSameInstance() {
        Charset charset1 = this.iteratorResultSetHandler.getCharset();
        Charset charset2 = this.iteratorResultSetHandler.getCharset();
        Assert.assertSame((Object)charset1, (Object)charset2);
    }

    @Test
    public void testProcessResultSetWithDifferentResultSets() throws SQLException {
        ResultSet mockResultSet2 = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetIterator result1 = this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        ResultSetIterator result2 = this.iteratorResultSetHandler.processResultSet(this.mockDbConnection, mockResultSet2);
        Assert.assertNotNull((Object)result1);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result1, (Object)result2);
        ((StatementStreamingResultSetCloser)Mockito.verify((Object)this.mockStreamingResultSetCloser)).trackResultSet(this.mockResultSet);
        ((StatementStreamingResultSetCloser)Mockito.verify((Object)this.mockStreamingResultSetCloser)).trackResultSet(mockResultSet2);
    }
}

