/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.param;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.resolver.param.StoredProcedureParamTypeResolver;
import org.mule.db.commons.internal.util.StoredProcedureUtils;
import org.mule.runtime.api.util.Pair;

@RunWith(value=MockitoJUnitRunner.class)
public class StoredProcedureParamTypeResolverTestCase {
    @Mock
    private DbTypeManager mockDbTypeManager;
    @Mock
    private DbConnection mockConnection;
    @Mock
    private QueryTemplate mockQueryTemplate;
    @Mock
    private Connection mockJdbcConnection;
    @Mock
    private DatabaseMetaData mockMetadata;
    @Mock
    private ResultSet mockProcedureColumns;
    @Mock
    private DbType mockDbType;
    private StoredProcedureParamTypeResolver resolver;
    private String originalForceProperty;

    @Before
    public void setUp() throws SQLException {
        this.resolver = new StoredProcedureParamTypeResolver(this.mockDbTypeManager);
        this.originalForceProperty = System.getProperty("mule.db.connector.force.sp.param.types");
        Mockito.when((Object)this.mockConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.getMetaData()).thenReturn((Object)this.mockMetadata);
        Mockito.when((Object)this.mockJdbcConnection.getCatalog()).thenReturn((Object)"test_catalog");
    }

    @After
    public void tearDown() {
        if (this.originalForceProperty != null) {
            System.setProperty("mule.db.connector.force.sp.param.types", this.originalForceProperty);
        } else {
            System.clearProperty("mule.db.connector.force.sp.param.types");
        }
    }

    @Test
    public void testGetParameterTypes_ForceParamTypes_AllParametersFound() throws SQLException {
        System.setProperty("mule.db.connector.force.sp.param.types", "true");
        QueryParam queryParam1 = this.createQueryParam("param1", 1);
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(Arrays.asList(queryParam1));
        ParameterType paramType1 = this.createParameterType("param1", this.mockDbType);
        List<ParameterType> configuredTypes = Arrays.asList(paramType1);
        Map result = this.resolver.getParameterTypes(this.mockConnection, this.mockQueryTemplate, configuredTypes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.mockDbType, result.get(1));
        ((DbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testGetParameterTypes_ForceParamTypes_MissingParameters_FallbackToMetadata() throws SQLException {
        try (MockedStatic mockedUtils = Mockito.mockStatic(StoredProcedureUtils.class);){
            System.setProperty("mule.db.connector.force.sp.param.types", "true");
            QueryParam queryParam1 = this.createQueryParam("param1", 1);
            QueryParam queryParam2 = this.createQueryParam("param2", 2);
            Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(Arrays.asList(queryParam1, queryParam2));
            Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)"CALL test_proc(?, ?)");
            ParameterType paramType1 = this.createParameterType("param1", this.mockDbType);
            List<ParameterType> configuredTypes = Arrays.asList(paramType1);
            this.setupMetadataFallback((MockedStatic<StoredProcedureUtils>)mockedUtils);
            Map result = this.resolver.getParameterTypes(this.mockConnection, this.mockQueryTemplate, configuredTypes);
            Assert.assertNotNull((Object)result);
            ((DbConnection)Mockito.verify((Object)this.mockConnection)).getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        }
    }

    @Test
    public void testGetParameterTypes_ForceParamTypesDisabled_DirectToMetadata() throws SQLException {
        try (MockedStatic mockedUtils = Mockito.mockStatic(StoredProcedureUtils.class);){
            System.setProperty("mule.db.connector.force.sp.param.types", "false");
            QueryParam queryParam1 = this.createQueryParam("param1", 1);
            Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(Arrays.asList(queryParam1));
            this.setupMetadataFallback((MockedStatic<StoredProcedureUtils>)mockedUtils);
            Map result = this.resolver.getParameterTypes(this.mockConnection, this.mockQueryTemplate, Arrays.asList(new ParameterType[0]));
            Assert.assertNotNull((Object)result);
            ((DbConnection)Mockito.verify((Object)this.mockConnection)).getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        }
    }

    @Test
    public void testGetParameterTypes_SystemPropertyDefault_DefaultToFalse() throws SQLException {
        try (MockedStatic mockedUtils = Mockito.mockStatic(StoredProcedureUtils.class);){
            System.clearProperty("mule.db.connector.force.sp.param.types");
            QueryParam queryParam1 = this.createQueryParam("param1", 1);
            Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(Arrays.asList(queryParam1));
            this.setupMetadataFallback((MockedStatic<StoredProcedureUtils>)mockedUtils);
            Map result = this.resolver.getParameterTypes(this.mockConnection, this.mockQueryTemplate, Arrays.asList(new ParameterType[0]));
            Assert.assertNotNull((Object)result);
            ((DbConnection)Mockito.verify((Object)this.mockConnection)).getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        }
    }

    @Test
    public void testGetParameterTypes_ForceParamTypes_EmptyConfiguredTypes() throws SQLException {
        try (MockedStatic mockedUtils = Mockito.mockStatic(StoredProcedureUtils.class);){
            System.setProperty("mule.db.connector.force.sp.param.types", "true");
            QueryParam queryParam1 = this.createQueryParam("param1", 1);
            Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(Arrays.asList(queryParam1));
            this.setupMetadataFallback((MockedStatic<StoredProcedureUtils>)mockedUtils);
            Map result = this.resolver.getParameterTypes(this.mockConnection, this.mockQueryTemplate, Arrays.asList(new ParameterType[0]));
            Assert.assertNotNull((Object)result);
            ((DbConnection)Mockito.verify((Object)this.mockConnection)).getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        }
    }

    @Test
    public void testConstructor() {
        StoredProcedureParamTypeResolver newResolver = new StoredProcedureParamTypeResolver(this.mockDbTypeManager);
        Assert.assertNotNull((Object)newResolver);
    }

    @Test
    public void testGetParameterTypes_MetadataThrowsSQLException() throws SQLException {
        try (MockedStatic mockedUtils = Mockito.mockStatic(StoredProcedureUtils.class);){
            System.setProperty("mule.db.connector.force.sp.param.types", "false");
            QueryParam queryParam1 = this.createQueryParam("param1", 1);
            Mockito.lenient().when((Object)this.mockQueryTemplate.getParams()).thenReturn(Arrays.asList(queryParam1));
            Mockito.lenient().when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)"CALL test_proc(?)");
            mockedUtils.when(() -> StoredProcedureUtils.analyzeStoredOperation((String)((String)ArgumentMatchers.any()))).thenReturn((Object)new Pair((Object)"test_proc", (Object)false));
            mockedUtils.when(() -> StoredProcedureUtils.getStoreProcedureOwner((String)((String)ArgumentMatchers.any()))).thenReturn(Optional.empty());
            mockedUtils.when(() -> StoredProcedureUtils.getStoredProcedureParentOwner((String)((String)ArgumentMatchers.any()))).thenReturn(Optional.empty());
            Mockito.when((Object)this.mockMetadata.storesUpperCaseIdentifiers()).thenReturn((Object)false);
            Mockito.when((Object)this.mockConnection.getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SQLException("Metadata error")});
            Assert.assertThrows(SQLException.class, () -> this.resolver.getParameterTypes(this.mockConnection, this.mockQueryTemplate, Arrays.asList(new ParameterType[0])));
        }
    }

    private QueryParam createQueryParam(String name, int index) {
        QueryParam queryParam = (QueryParam)Mockito.mock(QueryParam.class);
        Mockito.when((Object)queryParam.getName()).thenReturn((Object)name);
        Mockito.when((Object)queryParam.getIndex()).thenReturn((Object)index);
        return queryParam;
    }

    private ParameterType createParameterType(String key, DbType dbType) {
        ParameterType paramType = (ParameterType)Mockito.mock(ParameterType.class);
        Mockito.when((Object)paramType.getKey()).thenReturn((Object)key);
        Mockito.when((Object)paramType.getDbType()).thenReturn((Object)dbType);
        Mockito.when((Object)dbType.getName()).thenReturn((Object)"VARCHAR");
        return paramType;
    }

    private void setupMetadataFallback(MockedStatic<StoredProcedureUtils> mockedUtils) throws SQLException {
        mockedUtils.when(() -> StoredProcedureUtils.analyzeStoredOperation((String)((String)ArgumentMatchers.any()))).thenReturn((Object)new Pair((Object)"test_proc", (Object)false));
        mockedUtils.when(() -> StoredProcedureUtils.getStoreProcedureOwner((String)((String)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        mockedUtils.when(() -> StoredProcedureUtils.getStoredProcedureParentOwner((String)((String)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockMetadata.storesUpperCaseIdentifiers()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.mockProcedureColumns);
        Mockito.when((Object)this.mockProcedureColumns.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)this.mockProcedureColumns.getShort(5)).thenReturn((Object)1);
        Mockito.when((Object)this.mockProcedureColumns.getInt(6)).thenReturn((Object)12);
        Mockito.when((Object)this.mockProcedureColumns.getString(7)).thenReturn((Object)"VARCHAR");
        Mockito.when((Object)this.mockProcedureColumns.getString(4)).thenReturn((Object)"param1", (Object[])new String[]{"param2"});
        Mockito.when((Object)this.mockConnection.getDbTypeByVendor((String)ArgumentMatchers.any(), (ResultSet)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockDbTypeManager.lookup((DbConnection)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (String)ArgumentMatchers.any())).thenReturn((Object)this.mockDbType);
    }
}

