/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.TruncateStatementTypeDetector;

public class TruncateStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        TruncateStatementTypeDetector detector = new TruncateStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.TRUNCATE));
    }

    @Test
    public void validTruncateStatementTest() {
        TruncateStatementTypeDetector detector = new TruncateStatementTypeDetector();
        List<String> truncateStatements = Arrays.asList("truncate table pepe", "TRUNCATE TABLE MYTABLE", "TruncaTe Table ATable");
        for (String statement : truncateStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidTruncateStatementTest() {
        TruncateStatementTypeDetector detector = new TruncateStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("SELECT * FROM MY TABLE;", "MERGE FROM MYTABLE", "Insert into my table", "Truncate MyTable", "UPDATE delete from table");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

