/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.exception.connection.DbError;
import org.mule.db.commons.internal.operation.OperationErrorTypeProvider;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;

public class OperationErrorTypeProviderTestCase {
    @Test
    public void testGetErrorTypes() {
        OperationErrorTypeProvider provider = new OperationErrorTypeProvider();
        Set errorTypes = provider.getErrorTypes();
        Assert.assertNotNull((Object)errorTypes);
        Assert.assertEquals((long)3L, (long)errorTypes.size());
        Assert.assertTrue((boolean)errorTypes.contains(DbError.CONNECTIVITY));
        Assert.assertTrue((boolean)errorTypes.contains(DbError.BAD_SQL_SYNTAX));
        Assert.assertTrue((boolean)errorTypes.contains(DbError.QUERY_EXECUTION));
    }

    @Test
    public void testGetErrorTypesReturnsNewSet() {
        OperationErrorTypeProvider provider = new OperationErrorTypeProvider();
        Set errorTypes1 = provider.getErrorTypes();
        Set errorTypes2 = provider.getErrorTypes();
        Assert.assertNotSame((Object)errorTypes1, (Object)errorTypes2);
        Assert.assertEquals((Object)errorTypes1, (Object)errorTypes2);
    }

    @Test
    public void testClassImplementsErrorTypeProvider() {
        OperationErrorTypeProvider provider = new OperationErrorTypeProvider();
        Assert.assertTrue((boolean)(provider instanceof ErrorTypeProvider));
    }

    @Test
    public void testClassHasCorrectPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.operation", (Object)OperationErrorTypeProvider.class.getPackage().getName());
    }

    @Test
    public void testClassHasCorrectName() {
        Assert.assertEquals((Object)"OperationErrorTypeProvider", (Object)OperationErrorTypeProvider.class.getSimpleName());
    }

    @Test
    public void testErrorTypesAreUnique() {
        OperationErrorTypeProvider provider = new OperationErrorTypeProvider();
        Set errorTypes = provider.getErrorTypes();
        Assert.assertEquals((long)3L, (long)errorTypes.size());
        long connectivityCount = errorTypes.stream().filter(e -> e.equals(DbError.CONNECTIVITY)).count();
        long badSqlSyntaxCount = errorTypes.stream().filter(e -> e.equals(DbError.BAD_SQL_SYNTAX)).count();
        long queryExecutionCount = errorTypes.stream().filter(e -> e.equals(DbError.QUERY_EXECUTION)).count();
        Assert.assertEquals((long)1L, (long)connectivityCount);
        Assert.assertEquals((long)1L, (long)badSqlSyntaxCount);
        Assert.assertEquals((long)1L, (long)queryExecutionCount);
    }
}

