/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.param.QuerySettings;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.operation.BaseDbOperations;

public class BaseDbOperationsTest {
    @Test
    public void getStatementFactoryMustRoundUpTimeouts() {
        ConfigurableStatementFactory sf = (ConfigurableStatementFactory)Mockito.mock(ConfigurableStatementFactory.class);
        BaseDbOperations dbOps = new BaseDbOperations(null, sf, null){};
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.MILLISECONDS, Integer.valueOf(1), Integer.valueOf(1)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setQueryTimeout(1);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(0, TimeUnit.MILLISECONDS, Integer.valueOf(1), Integer.valueOf(1)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setQueryTimeout(0);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(1500, TimeUnit.MILLISECONDS, Integer.valueOf(1), Integer.valueOf(1)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setQueryTimeout(2);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(0, TimeUnit.SECONDS, Integer.valueOf(1), Integer.valueOf(1)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setQueryTimeout(0);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.SECONDS, Integer.valueOf(1), Integer.valueOf(1)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setQueryTimeout(1);
    }

    @Test
    public void getStatementFactoryMaxRows() {
        ConfigurableStatementFactory sf = (ConfigurableStatementFactory)Mockito.mock(ConfigurableStatementFactory.class);
        BaseDbOperations dbOps = new BaseDbOperations(null, sf, null){};
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.MILLISECONDS, Integer.valueOf(1), Integer.valueOf(1)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setMaxRows(1);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.MILLISECONDS, Integer.valueOf(1), Integer.valueOf(0)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setMaxRows(0);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.MILLISECONDS, Integer.valueOf(1), Integer.valueOf(10)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setMaxRows(10);
    }

    @Test
    public void getStatementFactoryFetchSize() {
        ConfigurableStatementFactory sf = (ConfigurableStatementFactory)Mockito.mock(ConfigurableStatementFactory.class);
        BaseDbOperations dbOps = new BaseDbOperations(null, sf, null){};
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.MILLISECONDS, Integer.valueOf(1), Integer.valueOf(1)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setFetchSize(1);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.MILLISECONDS, Integer.valueOf(10), Integer.valueOf(15)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setFetchSize(10);
        Mockito.reset((Object[])new ConfigurableStatementFactory[]{sf});
        dbOps.getStatementFactory(new QuerySettings(1, TimeUnit.MILLISECONDS, Integer.valueOf(0), Integer.valueOf(5)));
        ((ConfigurableStatementFactory)Mockito.verify((Object)sf)).setFetchSize(0);
    }
}

