/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.CompositeDbTypeManager;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.UnknownDbTypeException;

@RunWith(value=MockitoJUnitRunner.class)
public class CompositeDbTypeManagerTestCase {
    @Mock
    private DbTypeManager mockVendorTypeManager1;
    @Mock
    private DbTypeManager mockVendorTypeManager2;
    @Mock
    private DbTypeManager mockTypeManager1;
    @Mock
    private DbTypeManager mockTypeManager2;
    @Mock
    private DbConnection mockConnection;
    @Mock
    private DbType mockDbType;
    private CompositeDbTypeManager compositeManager;

    @Before
    public void setUp() {
    }

    @Test
    public void testConstructorWithVendorAndTypeManagers() {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1, this.mockVendorTypeManager2);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1, this.mockTypeManager2);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Assert.assertNotNull((Object)this.compositeManager);
    }

    @Test
    public void testConstructorWithTypeManagersOnly() {
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1, this.mockTypeManager2);
        this.compositeManager = new CompositeDbTypeManager(typeManagers);
        Assert.assertNotNull((Object)this.compositeManager);
    }

    @Test
    public void testConstructorWithEmptyLists() {
        List vendorManagers = Collections.emptyList();
        List typeManagers = Collections.emptyList();
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Assert.assertNotNull((Object)this.compositeManager);
    }

    @Test
    public void testConstructorWithNullLists() {
        List vendorManagers = null;
        List typeManagers = null;
        CompositeDbTypeManager manager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Assert.assertNotNull((Object)manager);
    }

    @Test
    public void testLookupWithIdAndNameSuccessInVendorManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, 1, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, 1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithIdAndNameSuccessInTypeManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException(1, "TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Mockito.when((Object)this.mockTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, 1, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, 1, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockTypeManager1)).lookup(this.mockConnection, 1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithIdAndNameSuccessInSecondVendorManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1, this.mockVendorTypeManager2);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException(1, "TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Mockito.when((Object)this.mockVendorTypeManager2.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, 1, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, 1, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager2)).lookup(this.mockConnection, 1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithIdAndNameSuccessInSecondTypeManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1, this.mockTypeManager2);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException(1, "TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException(1, "TEST_TYPE")}).when((Object)this.mockTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Mockito.when((Object)this.mockTypeManager2.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, 1, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, 1, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockTypeManager1)).lookup(this.mockConnection, 1, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockTypeManager2)).lookup(this.mockConnection, 1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithIdAndNameFailure() {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException(1, "TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException(1, "TEST_TYPE")}).when((Object)this.mockTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Assert.assertThrows(UnknownDbTypeException.class, () -> this.compositeManager.lookup(this.mockConnection, 1, "TEST_TYPE"));
    }

    @Test
    public void testLookupWithNameSuccessInVendorManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, "TEST_TYPE");
    }

    @Test
    public void testLookupWithNameSuccessInTypeManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException("TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString());
        Mockito.when((Object)this.mockTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockTypeManager1)).lookup(this.mockConnection, "TEST_TYPE");
    }

    @Test
    public void testLookupWithNameSuccessInSecondVendorManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1, this.mockVendorTypeManager2);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException("TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString());
        Mockito.when((Object)this.mockVendorTypeManager2.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager2)).lookup(this.mockConnection, "TEST_TYPE");
    }

    @Test
    public void testLookupWithNameSuccessInSecondTypeManager() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1, this.mockTypeManager2);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException("TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString());
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException("TEST_TYPE")}).when((Object)this.mockTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString());
        Mockito.when((Object)this.mockTypeManager2.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockTypeManager1)).lookup(this.mockConnection, "TEST_TYPE");
        ((DbTypeManager)Mockito.verify((Object)this.mockTypeManager2)).lookup(this.mockConnection, "TEST_TYPE");
    }

    @Test
    public void testLookupWithNameFailure() {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException("TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString());
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException("TEST_TYPE")}).when((Object)this.mockTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString());
        Assert.assertThrows(UnknownDbTypeException.class, () -> this.compositeManager.lookup(this.mockConnection, "TEST_TYPE"));
    }

    @Test
    public void testLookupWithEmptyVendorManagers() throws UnknownDbTypeException {
        List vendorManagers = Collections.emptyList();
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, 1, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockTypeManager1)).lookup(this.mockConnection, 1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithEmptyTypeManagers() {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List typeManagers = Collections.emptyList();
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        ((DbTypeManager)Mockito.doThrow((Throwable[])new Throwable[]{new UnknownDbTypeException(1, "TEST_TYPE")}).when((Object)this.mockVendorTypeManager1)).lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Assert.assertThrows(UnknownDbTypeException.class, () -> this.compositeManager.lookup(this.mockConnection, 1, "TEST_TYPE"));
    }

    @Test
    public void testLookupWithNullConnection() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.eq(null), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"TEST_TYPE"))).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(null, 1, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(null, 1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithNullName() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.eq((Object)this.mockConnection), (String)ArgumentMatchers.eq(null))).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, null);
    }

    @Test
    public void testLookupWithEmptyName() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, "");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, "");
    }

    @Test
    public void testLookupWithNegativeId() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, -1, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, -1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithZeroId() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, 0, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, 0, "TEST_TYPE");
    }

    @Test
    public void testLookupWithLargeId() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, 999999, "TEST_TYPE");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, 999999, "TEST_TYPE");
    }

    @Test
    public void testLookupWithSpecialCharactersInName() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, "TEST_TYPE_WITH_SPECIAL_CHARS_!@#$%^&*()");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, "TEST_TYPE_WITH_SPECIAL_CHARS_!@#$%^&*()");
    }

    @Test
    public void testLookupWithUnicodeName() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        DbType result = this.compositeManager.lookup(this.mockConnection, "TEST_TYPE_WITH_UNICODE_\u4f60\u597d\u4e16\u754c");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, "TEST_TYPE_WITH_UNICODE_\u4f60\u597d\u4e16\u754c");
    }

    @Test
    public void testLookupWithVeryLongName() throws UnknownDbTypeException {
        List<DbTypeManager> vendorManagers = Arrays.asList(this.mockVendorTypeManager1);
        List<DbTypeManager> typeManagers = Arrays.asList(this.mockTypeManager1);
        this.compositeManager = new CompositeDbTypeManager(vendorManagers, typeManagers);
        Mockito.when((Object)this.mockVendorTypeManager1.lookup((DbConnection)ArgumentMatchers.any(DbConnection.class), ArgumentMatchers.anyString())).thenReturn((Object)this.mockDbType);
        StringBuilder longName = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            longName.append("A");
        }
        DbType result = this.compositeManager.lookup(this.mockConnection, longName.toString());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockDbType, (Object)result);
        ((DbTypeManager)Mockito.verify((Object)this.mockVendorTypeManager1)).lookup(this.mockConnection, longName.toString());
    }
}

