/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.metadata;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.metadata.StoredProcedureMetadataResolver;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class StoredProcedureMetadataResolverTestCase
extends AbstractMuleTestCase {
    private StoredProcedureMetadataResolver resolver;
    private MetadataContext mockContext;
    private BaseTypeBuilder mockBaseTypeBuilder;
    private ObjectTypeBuilder mockObjectTypeBuilder;
    private ObjectType mockObjectType;

    @Before
    public void setUp() {
        this.resolver = new StoredProcedureMetadataResolver();
        this.mockContext = (MetadataContext)Mockito.mock(MetadataContext.class);
        this.mockBaseTypeBuilder = (BaseTypeBuilder)Mockito.mock(BaseTypeBuilder.class);
        this.mockObjectTypeBuilder = (ObjectTypeBuilder)Mockito.mock(ObjectTypeBuilder.class);
        this.mockObjectType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)this.mockContext.getTypeBuilder()).thenReturn((Object)this.mockBaseTypeBuilder);
        Mockito.when((Object)this.mockBaseTypeBuilder.objectType()).thenReturn((Object)this.mockObjectTypeBuilder);
        Mockito.when((Object)this.mockObjectTypeBuilder.build()).thenReturn((Object)this.mockObjectType);
    }

    @Test
    public void testGetCategoryName() {
        String categoryName = this.resolver.getCategoryName();
        MatcherAssert.assertThat((Object)categoryName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)"DbCategory", (Object)categoryName);
    }

    @Test
    public void testGetOutputType() throws MetadataResolvingException, ConnectionException {
        String query = "CALL test_procedure()";
        MetadataType result = this.resolver.getOutputType(this.mockContext, query);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)this.mockObjectType, (Object)result);
    }

    @Test
    public void testGetOutputTypeWithNullQuery() throws MetadataResolvingException, ConnectionException {
        MetadataType result = this.resolver.getOutputType(this.mockContext, null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)this.mockObjectType, (Object)result);
    }

    @Test
    public void testGetOutputTypeWithEmptyQuery() throws MetadataResolvingException, ConnectionException {
        MetadataType result = this.resolver.getOutputType(this.mockContext, "");
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)this.mockObjectType, (Object)result);
    }

    @Test
    public void testGetOutputTypeWithComplexQuery() throws MetadataResolvingException, ConnectionException {
        String complexQuery = "CALL complex_procedure(?, ?, ?)";
        MetadataType result = this.resolver.getOutputType(this.mockContext, complexQuery);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)this.mockObjectType, (Object)result);
    }

    @Test
    public void testInheritance() {
        MatcherAssert.assertThat((Object)this.resolver, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(this.resolver instanceof StoredProcedureMetadataResolver));
        Assert.assertTrue((boolean)(this.resolver instanceof OutputTypeResolver));
    }

    @Test
    public void testResolverProperties() {
        Assert.assertEquals((Object)"DbCategory", (Object)this.resolver.getCategoryName());
    }

    @Test
    public void testResolverConsistency() {
        String categoryName1 = this.resolver.getCategoryName();
        String categoryName2 = this.resolver.getCategoryName();
        Assert.assertEquals((Object)categoryName1, (Object)categoryName2);
    }

    @Test
    public void testGetOutputTypeConsistency() throws MetadataResolvingException, ConnectionException {
        String query = "CALL test_procedure()";
        MetadataType result1 = this.resolver.getOutputType(this.mockContext, query);
        MetadataType result2 = this.resolver.getOutputType(this.mockContext, query);
        MatcherAssert.assertThat((Object)result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)result1, (Object)result2);
    }
}

