/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.metadata;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.db.commons.internal.domain.metadata.BaseDbMetadataResolver;
import org.mule.db.commons.internal.domain.metadata.QuerySingleMetadataResolver;
import org.mule.db.commons.internal.domain.metadata.SelectMetadataResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class QuerySingleMetadataResolverTestCase
extends AbstractMuleTestCase {
    private QuerySingleMetadataResolver resolver;

    @Before
    public void setUp() {
        this.resolver = new QuerySingleMetadataResolver();
    }

    @Test
    public void testGetCategoryName() {
        String categoryName = this.resolver.getCategoryName();
        MatcherAssert.assertThat((Object)categoryName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)"DbCategory", (Object)categoryName);
    }

    @Test
    public void testGetResolverName() {
        String resolverName = this.resolver.getResolverName();
        MatcherAssert.assertThat((Object)resolverName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)"QuerySingleResolver", (Object)resolverName);
    }

    @Test
    public void testInheritance() {
        MatcherAssert.assertThat((Object)this.resolver, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(this.resolver instanceof QuerySingleMetadataResolver));
        Assert.assertTrue((boolean)(this.resolver instanceof SelectMetadataResolver));
        Assert.assertTrue((boolean)(this.resolver instanceof BaseDbMetadataResolver));
    }

    @Test
    public void testResolverProperties() {
        Assert.assertEquals((Object)"DbCategory", (Object)this.resolver.getCategoryName());
        Assert.assertEquals((Object)"QuerySingleResolver", (Object)this.resolver.getResolverName());
    }

    @Test
    public void testResolverConsistency() {
        String categoryName1 = this.resolver.getCategoryName();
        String categoryName2 = this.resolver.getCategoryName();
        String resolverName1 = this.resolver.getResolverName();
        String resolverName2 = this.resolver.getResolverName();
        Assert.assertEquals((Object)categoryName1, (Object)categoryName2);
        Assert.assertEquals((Object)resolverName1, (Object)resolverName2);
    }
}

