/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.logger;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.logger.AbstractNullQueryLogger;
import org.mule.db.commons.internal.domain.logger.BulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.NullBulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.QueryLogger;

@RunWith(value=MockitoJUnitRunner.class)
public class NullBulkQueryLoggerTestCase {
    private NullBulkQueryLogger logger;

    @Before
    public void setUp() {
        this.logger = new NullBulkQueryLogger();
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.logger);
    }

    @Test
    public void testLogQuery() {
        this.logger.logQuery();
    }

    @Test
    public void testAddQueryWithNullQuery() {
        this.logger.addQuery(null);
    }

    @Test
    public void testAddQueryWithEmptyString() {
        this.logger.addQuery("");
    }

    @Test
    public void testAddQueryWithValidQuery() {
        this.logger.addQuery("INSERT INTO users (name, email) VALUES (?, ?)");
    }

    @Test
    public void testMultipleLogQueryCalls() {
        this.logger.logQuery();
        this.logger.logQuery();
        this.logger.logQuery();
    }

    @Test
    public void testMultipleAddQueryCalls() {
        this.logger.addQuery("INSERT INTO users (name) VALUES (?)");
        this.logger.addQuery("UPDATE users SET email = ? WHERE id = ?");
        this.logger.addQuery("DELETE FROM users WHERE id = ?");
    }

    @Test
    public void testLoggerImplementsBulkQueryLogger() {
        Assert.assertTrue((boolean)(this.logger instanceof BulkQueryLogger));
    }

    @Test
    public void testLoggerImplementsQueryLogger() {
        Assert.assertTrue((boolean)(this.logger instanceof QueryLogger));
    }

    @Test
    public void testLoggerExtendsAbstractNullQueryLogger() {
        Assert.assertTrue((boolean)(this.logger instanceof AbstractNullQueryLogger));
    }

    @Test
    public void testLoggerPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.logger", (Object)NullBulkQueryLogger.class.getPackage().getName());
    }

    @Test
    public void testLoggerClassName() {
        Assert.assertEquals((Object)"NullBulkQueryLogger", (Object)NullBulkQueryLogger.class.getSimpleName());
    }

    @Test
    public void testLoggerFullClassName() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.logger.NullBulkQueryLogger", (Object)NullBulkQueryLogger.class.getName());
    }

    @Test
    public void testMultipleInstances() {
        NullBulkQueryLogger logger1 = new NullBulkQueryLogger();
        NullBulkQueryLogger logger2 = new NullBulkQueryLogger();
        Assert.assertNotNull((Object)logger1);
        Assert.assertNotNull((Object)logger2);
        Assert.assertNotSame((Object)logger1, (Object)logger2);
    }

    @Test
    public void testAddQueryWithDifferentQueryTypes() {
        this.logger.addQuery("SELECT * FROM users");
        this.logger.addQuery("INSERT INTO users (name, email) VALUES (?, ?)");
        this.logger.addQuery("UPDATE users SET name = ? WHERE id = ?");
        this.logger.addQuery("DELETE FROM users WHERE id = ?");
        this.logger.addQuery("CREATE TABLE users (id INT, name VARCHAR(255))");
        this.logger.addQuery("DROP TABLE users");
    }

    @Test
    public void testAddQueryWithSpecialCharacters() {
        this.logger.addQuery("SELECT * FROM users WHERE name LIKE '%test%'");
        this.logger.addQuery("INSERT INTO \"users\" (\"name\") VALUES (?)");
        this.logger.addQuery("UPDATE users SET name = 'O''Connor' WHERE id = ?");
    }

    @Test
    public void testAddQueryWithUnicodeCharacters() {
        this.logger.addQuery("SELECT * FROM users WHERE name = '\u4f60\u597d\u4e16\u754c'");
        this.logger.addQuery("INSERT INTO users (name) VALUES ('Jos\u00e9 Mar\u00eda')");
    }

    @Test
    public void testAddQueryWithVeryLongQuery() {
        StringBuilder longQuery = new StringBuilder();
        longQuery.append("SELECT u.id, u.name, u.email, p.title, p.content, c.comment ");
        longQuery.append("FROM users u ");
        longQuery.append("LEFT JOIN posts p ON u.id = p.user_id ");
        longQuery.append("LEFT JOIN comments c ON p.id = c.post_id ");
        longQuery.append("WHERE u.active = true ");
        longQuery.append("AND u.created_date > '2023-01-01' ");
        longQuery.append("ORDER BY u.name, p.created_date DESC");
        this.logger.addQuery(longQuery.toString());
    }

    @Test
    public void testAddQueryWithComplexQuery() {
        String complexQuery = "WITH RECURSIVE cte AS (SELECT id, name, parent_id, 1 as level FROM categories WHERE parent_id IS NULL UNION ALL SELECT c.id, c.name, c.parent_id, cte.level + 1 FROM categories c INNER JOIN cte ON c.parent_id = cte.id WHERE cte.level < 10) SELECT * FROM cte";
        this.logger.addQuery(complexQuery);
    }

    @Test
    public void testAddQueryWithWhitespaceOnly() {
        this.logger.addQuery("   ");
        this.logger.addQuery("\t");
        this.logger.addQuery("\n");
    }

    @Test
    public void testAddQueryWithNumbers() {
        this.logger.addQuery("SELECT * FROM users LIMIT 100");
        this.logger.addQuery("UPDATE users SET count = 42 WHERE id = 1");
    }
}

