/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.executor;

import java.sql.SQLException;
import java.sql.Statement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.executor.AbstractSingleQueryExecutor;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.statement.StatementFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class AbstractSingleQueryExecutorTestCase
extends AbstractMuleTestCase {
    @Mock
    private StatementFactory statementFactory;
    @Mock
    private Statement statement;
    @Mock
    private AutoGenerateKeysStrategy autoGenerateKeysStrategy;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Query query;
    @Mock
    private DbConnection dbConnection;
    @Mock
    private SQLException sqlException;
    private AbstractSingleQueryExecutor executor;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.statementFactory.create((DbConnection)ArgumentMatchers.any(DbConnection.class), (QueryTemplate)ArgumentMatchers.any(QueryTemplate.class), (AutoGenerateKeysStrategy)ArgumentMatchers.any(AutoGenerateKeysStrategy.class))).thenReturn((Object)this.statement);
        Mockito.when((Object)this.statementFactory.create((DbConnection)ArgumentMatchers.any(DbConnection.class), (QueryTemplate)ArgumentMatchers.any(QueryTemplate.class))).thenReturn((Object)this.statement);
        this.executor = new AbstractSingleQueryExecutor(this.statementFactory){

            protected Object doExecuteQuery(DbConnection connection, Statement statement, Query query) throws SQLException {
                throw AbstractSingleQueryExecutorTestCase.this.sqlException;
            }

            protected Object doExecuteQuery(DbConnection dbConnection, Statement statement, Query query, AutoGenerateKeysStrategy autoGenerateKeysStrategy) throws SQLException {
                throw AbstractSingleQueryExecutorTestCase.this.sqlException;
            }
        };
    }

    @Test
    public void statementClosedWhenFailedUsingKeyGeneration() throws Exception {
        try {
            this.executor.execute(this.dbConnection, this.query, this.autoGenerateKeysStrategy);
            Assert.fail((String)"Was expecting a failure");
        }
        catch (SQLException e) {
            this.assertExpectedException(e);
            this.assertStatementClosed();
        }
    }

    @Test
    public void statementClosedWhenFailedWithoutKeyGeneration() throws Exception {
        try {
            this.executor.execute(this.dbConnection, this.query);
            Assert.fail((String)"Was expecting a failure");
        }
        catch (SQLException e) {
            this.assertExpectedException(e);
            this.assertStatementClosed();
        }
    }

    private void assertStatementClosed() throws SQLException {
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    private void assertExpectedException(SQLException e) {
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.sqlException)));
    }
}

