/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.type.resolver;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.connection.type.resolver.StructAndArrayTypeResolver;
import org.mule.db.commons.internal.domain.connection.type.resolver.StructTypeResolver;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

@RunWith(value=MockitoJUnitRunner.class)
public class StructTypeResolverTestCase {
    @Mock
    private DefaultDbConnection mockConnection;
    @Mock
    private ResolvedDbType mockResolvedDbType;
    private StructTypeResolver structTypeResolver;

    @Before
    public void setUp() {
        this.structTypeResolver = new StructTypeResolver(this.mockConnection);
    }

    @Test
    public void testConstructor() {
        StructTypeResolver resolver = new StructTypeResolver(this.mockConnection);
        Assert.assertNotNull((Object)resolver);
    }

    @Test
    public void testConstructorWithNullConnection() {
        StructTypeResolver resolver = new StructTypeResolver(null);
        Assert.assertNotNull((Object)resolver);
    }

    @Test
    public void testResolveTypeWithSimpleTypeName() {
        String typeName = "VARCHAR";
        String result = this.structTypeResolver.resolveType(typeName);
        Assert.assertEquals((Object)typeName, (Object)result);
    }

    @Test
    public void testResolveTypeWithNullTypeName() {
        String result = this.structTypeResolver.resolveType(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTypeWithEmptyTypeName() {
        String result = this.structTypeResolver.resolveType("");
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testResolveTypeWithWhitespaceTypeName() {
        String result = this.structTypeResolver.resolveType("   ");
        Assert.assertEquals((Object)"   ", (Object)result);
    }

    @Test
    public void testResolveTypeWithSpecialCharacters() {
        String typeName = "CUSTOM_TYPE_123";
        String result = this.structTypeResolver.resolveType(typeName);
        Assert.assertEquals((Object)typeName, (Object)result);
    }

    @Test
    public void testResolveTypeWithUnicodeCharacters() {
        String typeName = "TYP\u00c9_\u00d1AME";
        String result = this.structTypeResolver.resolveType(typeName);
        Assert.assertEquals((Object)typeName, (Object)result);
    }

    @Test
    public void testResolveTypeWithVeryLongTypeName() {
        String longTypeName = new String(new char[1000]).replace("\u0000", "A");
        String result = this.structTypeResolver.resolveType(longTypeName);
        Assert.assertEquals((Object)longTypeName, (Object)result);
    }

    @Test
    public void testResolveTypeWithTypeCache() throws SQLException {
        String typeName = "INTEGER";
        ConcurrentHashMap typeCache = new ConcurrentHashMap();
        String result = this.structTypeResolver.resolveType(typeName, typeCache);
        Assert.assertEquals((Object)typeName, (Object)result);
    }

    @Test
    public void testResolveTypeWithTypeCacheAndNullTypeName() throws SQLException {
        ConcurrentHashMap typeCache = new ConcurrentHashMap();
        String result = this.structTypeResolver.resolveType(null, typeCache);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTypeWithTypeCacheAndEmptyTypeName() throws SQLException {
        ConcurrentHashMap typeCache = new ConcurrentHashMap();
        String result = this.structTypeResolver.resolveType("", typeCache);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testResolveTypeWithNullTypeCache() throws SQLException {
        String typeName = "VARCHAR";
        String result = this.structTypeResolver.resolveType(typeName, null);
        Assert.assertEquals((Object)typeName, (Object)result);
    }

    @Test
    public void testResolveTypeWithTypeCacheAndSpecialCharacters() throws SQLException {
        String typeName = "CUSTOM_TYPE_@#$%";
        ConcurrentHashMap typeCache = new ConcurrentHashMap();
        String result = this.structTypeResolver.resolveType(typeName, typeCache);
        Assert.assertEquals((Object)typeName, (Object)result);
    }

    @Test
    public void testResolveLobs() throws SQLException {
        Object[] elements = new Object[]{"value1", "value2", "value3"};
        Integer index = 1;
        String dataTypeName = "CLOB";
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(elements, index.intValue(), dataTypeName);
    }

    @Test
    public void testResolveLobsWithNullElements() throws SQLException {
        Integer index = 0;
        String dataTypeName = "BLOB";
        this.structTypeResolver.resolveLobs(null, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(null, index.intValue(), dataTypeName);
    }

    @Test
    public void testResolveLobsWithEmptyElements() throws SQLException {
        Object[] elements = new Object[]{};
        Integer index = 0;
        String dataTypeName = "CLOB";
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(elements, index.intValue(), dataTypeName);
    }

    @Test
    public void testResolveLobsWithNullDataTypeName() throws SQLException {
        Object[] elements = new Object[]{"value1", "value2"};
        Integer index = 1;
        this.structTypeResolver.resolveLobs(elements, index, null);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(elements, index.intValue(), null);
    }

    @Test
    public void testResolveLobsWithNegativeIndex() throws SQLException {
        Object[] elements = new Object[]{"value1", "value2"};
        Integer index = -1;
        String dataTypeName = "CLOB";
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(elements, index.intValue(), dataTypeName);
    }

    @Test
    public void testResolveLobsWithLargeIndex() throws SQLException {
        Object[] elements = new Object[]{"value1", "value2"};
        Integer index = Integer.MAX_VALUE;
        String dataTypeName = "BLOB";
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(elements, index.intValue(), dataTypeName);
    }

    @Test
    public void testResolveLobsWithEmptyDataTypeName() throws SQLException {
        Object[] elements = new Object[]{"value1", "value2"};
        Integer index = 1;
        String dataTypeName = "";
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(elements, index.intValue(), dataTypeName);
    }

    @Test
    public void testResolveLobsWithWhitespaceDataTypeName() throws SQLException {
        Object[] elements = new Object[]{"value1", "value2"};
        Integer index = 1;
        String dataTypeName = "   ";
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(elements, index.intValue(), dataTypeName);
    }

    @Test
    public void testResolveLobIn() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2", "attr3"};
        Integer index = 2;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)1);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"TEST_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 1, "TEST_TYPE");
    }

    @Test
    public void testResolveLobInWithNullAttributes() throws SQLException {
        Integer index = 0;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)2);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"NULL_TYPE");
        this.structTypeResolver.resolveLobIn(null, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(null, index.intValue(), 2, "NULL_TYPE");
    }

    @Test
    public void testResolveLobInWithEmptyAttributes() throws SQLException {
        Object[] attributes = new Object[]{};
        Integer index = 0;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)3);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"EMPTY_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 3, "EMPTY_TYPE");
    }

    @Test
    public void testResolveLobInWithNegativeIndex() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = -1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)5);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"NEGATIVE_INDEX_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 5, "NEGATIVE_INDEX_TYPE");
    }

    @Test
    public void testResolveLobInWithLargeIndex() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = Integer.MAX_VALUE;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)6);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"LARGE_INDEX_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 6, "LARGE_INDEX_TYPE");
    }

    @Test
    public void testResolveLobInWithZeroId() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)0);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"ZERO_ID_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 0, "ZERO_ID_TYPE");
    }

    @Test
    public void testResolveLobInWithNegativeId() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)-1);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"NEGATIVE_ID_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), -1, "NEGATIVE_ID_TYPE");
    }

    @Test
    public void testResolveLobInWithNullName() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)7);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn(null);
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 7, null);
    }

    @Test
    public void testResolveLobInWithEmptyName() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)8);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 8, "");
    }

    @Test
    public void testResolveLobInWithWhitespaceName() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)9);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"   ");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 9, "   ");
    }

    @Test
    public void testResolveLobInWithSpecialCharactersInName() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)10);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"SPECIAL@#$%_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 10, "SPECIAL@#$%_TYPE");
    }

    @Test
    public void testResolveLobInWithUnicodeCharactersInName() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)11);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"UNICODE_\u00d1AME_TYPE");
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 11, "UNICODE_\u00d1AME_TYPE");
    }

    @Test
    public void testResolveLobInWithVeryLongName() throws SQLException {
        Object[] attributes = new Object[]{"attr1", "attr2"};
        Integer index = 1;
        String longName = new String(new char[1000]).replace("\u0000", "A");
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)12);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)longName);
        this.structTypeResolver.resolveLobIn(attributes, index, this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn(attributes, index.intValue(), 12, longName);
    }

    @Test
    public void testMultipleInstancesAreIndependent() {
        StructTypeResolver resolver1 = new StructTypeResolver(this.mockConnection);
        StructTypeResolver resolver2 = new StructTypeResolver(this.mockConnection);
        Assert.assertNotNull((Object)resolver1);
        Assert.assertNotNull((Object)resolver2);
        Assert.assertNotSame((Object)resolver1, (Object)resolver2);
    }

    @Test
    public void testInstanceCanBeReused() throws SQLException {
        Object[] elements = new Object[]{"value1", "value2"};
        Integer index = 1;
        String dataTypeName = "CLOB";
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        this.structTypeResolver.resolveLobs(elements, index, dataTypeName);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).doResolveLobIn(elements, index.intValue(), dataTypeName);
    }

    @Test
    public void testClassHasCorrectPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.connection.type.resolver", (Object)StructTypeResolver.class.getPackage().getName());
    }

    @Test
    public void testClassHasCorrectName() {
        Assert.assertEquals((Object)"StructTypeResolver", (Object)StructTypeResolver.class.getSimpleName());
    }

    @Test
    public void testClassImplementsStructAndArrayTypeResolver() {
        Assert.assertTrue((boolean)StructAndArrayTypeResolver.class.isAssignableFrom(StructTypeResolver.class));
    }

    @Test
    public void testClassIsPublic() {
        Assert.assertTrue((boolean)Modifier.isPublic(StructTypeResolver.class.getModifiers()));
    }

    @Test
    public void testClassIsNotAbstract() {
        Assert.assertFalse((boolean)Modifier.isAbstract(StructTypeResolver.class.getModifiers()));
    }

    @Test
    public void testClassIsNotFinal() {
        Assert.assertFalse((boolean)Modifier.isFinal(StructTypeResolver.class.getModifiers()));
    }

    @Test
    public void testConstructorIsPublic() throws Exception {
        Constructor constructor = StructTypeResolver.class.getDeclaredConstructor(DefaultDbConnection.class);
        Assert.assertTrue((boolean)Modifier.isPublic(constructor.getModifiers()));
    }

    @Test
    public void testConstructorTakesOneParameter() throws Exception {
        Constructor constructor = StructTypeResolver.class.getDeclaredConstructor(DefaultDbConnection.class);
        Assert.assertEquals((long)1L, (long)constructor.getParameterCount());
    }

    @Test
    public void testConstructorParameterType() throws Exception {
        Constructor constructor = StructTypeResolver.class.getDeclaredConstructor(DefaultDbConnection.class);
        Assert.assertEquals(DefaultDbConnection.class, constructor.getParameterTypes()[0]);
    }

    @Test
    public void testResolveTypeMethodIsPublic() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveType", String.class);
        Assert.assertTrue((boolean)Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void testResolveTypeMethodReturnsString() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveType", String.class);
        Assert.assertEquals(String.class, method.getReturnType());
    }

    @Test
    public void testResolveTypeWithCacheMethodIsPublic() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveType", String.class, ConcurrentHashMap.class);
        Assert.assertTrue((boolean)Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void testResolveTypeWithCacheMethodReturnsString() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveType", String.class, ConcurrentHashMap.class);
        Assert.assertEquals(String.class, method.getReturnType());
    }

    @Test
    public void testResolveLobsMethodIsPublic() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveLobs", Object[].class, Integer.class, String.class);
        Assert.assertTrue((boolean)Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void testResolveLobsMethodThrowsSQLException() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveLobs", Object[].class, Integer.class, String.class);
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        boolean throwsSQLException = false;
        for (Class<?> exceptionType : exceptionTypes) {
            if (!exceptionType.equals(SQLException.class)) continue;
            throwsSQLException = true;
            break;
        }
        Assert.assertTrue((String)"resolveLobs method should throw SQLException", (boolean)throwsSQLException);
    }

    @Test
    public void testResolveLobInMethodIsPublic() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveLobIn", Object[].class, Integer.class, ResolvedDbType.class);
        Assert.assertTrue((boolean)Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void testResolveLobInMethodThrowsSQLException() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveLobIn", Object[].class, Integer.class, ResolvedDbType.class);
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        boolean throwsSQLException = false;
        for (Class<?> exceptionType : exceptionTypes) {
            if (!exceptionType.equals(SQLException.class)) continue;
            throwsSQLException = true;
            break;
        }
        Assert.assertTrue((String)"resolveLobIn method should throw SQLException", (boolean)throwsSQLException);
    }

    @Test
    public void testResolveTypeWithCacheMethodThrowsSQLException() throws Exception {
        Method method = StructTypeResolver.class.getDeclaredMethod("resolveType", String.class, ConcurrentHashMap.class);
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        boolean throwsSQLException = false;
        for (Class<?> exceptionType : exceptionTypes) {
            if (!exceptionType.equals(SQLException.class)) continue;
            throwsSQLException = true;
            break;
        }
        Assert.assertTrue((String)"resolveType with cache method should throw SQLException", (boolean)throwsSQLException);
    }

    @Test
    public void testConnectionFieldIsPrivate() throws Exception {
        Field connectionField = StructTypeResolver.class.getDeclaredField("connection");
        Assert.assertTrue((boolean)Modifier.isPrivate(connectionField.getModifiers()));
    }

    @Test
    public void testConnectionFieldType() throws Exception {
        Field connectionField = StructTypeResolver.class.getDeclaredField("connection");
        Assert.assertEquals(DefaultDbConnection.class, connectionField.getType());
    }
}

