/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.connection.enhydra.wrappers.StandardDataSourceWrapper;
import org.mule.runtime.api.tls.TlsContextFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardDataSourceWrapperTestCase {
    @Mock
    private TlsContextFactory mockTlsContextFactory;
    @Mock
    private Connection mockConnection;

    @Test
    public void testConstructorWithTlsContextFactory() {
        StandardDataSourceWrapper wrapper = new StandardDataSourceWrapper(this.mockTlsContextFactory);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertTrue((boolean)(wrapper instanceof StandardDataSourceWrapper));
    }

    @Test
    public void testConstructorWithNullTlsContextFactory() {
        StandardDataSourceWrapper wrapper = new StandardDataSourceWrapper(null);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertTrue((boolean)(wrapper instanceof StandardDataSourceWrapper));
    }

    @Test
    public void testGetConnectionWithUserAndPassword() throws SQLException {
        StandardDataSourceWrapper wrapper = new StandardDataSourceWrapper(this.mockTlsContextFactory);
        String user = "testUser";
        String password = "testPassword";
        try {
            Connection connection = wrapper.getConnection(user, password);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetConnectionWithNullCredentials() throws SQLException {
        StandardDataSourceWrapper wrapper = new StandardDataSourceWrapper(this.mockTlsContextFactory);
        try {
            Connection connection = wrapper.getConnection(null, null);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetConnectionWithEmptyCredentials() throws SQLException {
        StandardDataSourceWrapper wrapper = new StandardDataSourceWrapper(this.mockTlsContextFactory);
        try {
            Connection connection = wrapper.getConnection("", "");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetConnectionWithNullTlsContextFactory() throws SQLException {
        StandardDataSourceWrapper wrapper = new StandardDataSourceWrapper(null);
        try {
            Connection connection = wrapper.getConnection("user", "password");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testClassHasCorrectPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.connection.enhydra.wrappers", (Object)StandardDataSourceWrapper.class.getPackage().getName());
    }

    @Test
    public void testClassHasCorrectName() {
        Assert.assertEquals((Object)"StandardDataSourceWrapper", (Object)StandardDataSourceWrapper.class.getSimpleName());
    }

    @Test
    public void testClassExtendsStandardDataSource() {
        Assert.assertTrue((boolean)StandardDataSourceWrapper.class.getSuperclass().equals(StandardDataSource.class));
    }

    @Test
    public void testGetConnectionMethodIsSynchronized() throws Exception {
        Method getConnectionMethod = StandardDataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Assert.assertTrue((boolean)Modifier.isSynchronized(getConnectionMethod.getModifiers()));
    }

    @Test
    public void testGetConnectionMethodThrowsSQLException() throws Exception {
        Method getConnectionMethod = StandardDataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Class<?>[] exceptionTypes = getConnectionMethod.getExceptionTypes();
        boolean throwsSQLException = false;
        for (Class<?> exceptionType : exceptionTypes) {
            if (!exceptionType.equals(SQLException.class)) continue;
            throwsSQLException = true;
            break;
        }
        Assert.assertTrue((String)"getConnection method should throw SQLException", (boolean)throwsSQLException);
    }

    @Test
    public void testGetConnectionMethodReturnsConnection() throws Exception {
        Method getConnectionMethod = StandardDataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Assert.assertEquals(Connection.class, getConnectionMethod.getReturnType());
    }

    @Test
    public void testGetConnectionMethodParameters() throws Exception {
        Method getConnectionMethod = StandardDataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Class<?>[] parameterTypes = getConnectionMethod.getParameterTypes();
        Assert.assertEquals((long)2L, (long)parameterTypes.length);
        Assert.assertEquals(String.class, parameterTypes[0]);
        Assert.assertEquals(String.class, parameterTypes[1]);
    }
}

