/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.connection.enhydra.wrappers.AbstractDataSourceWrapper;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class AbstractDataSourceWrapperTestCase
extends AbstractMuleTestCase {
    @Test
    public void testConstructor() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        MatcherAssert.assertThat((Object)wrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testClassExists() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        MatcherAssert.assertThat((Object)wrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)wrapper.getClass().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.connection.enhydra.wrappers.AbstractDataSourceWrapper"));
    }

    @Test
    public void testMethodExists() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        try {
            Method method = wrapper.getClass().getMethod("getSecureConnectionIfPossible", String.class, String.class, StandardDataSource.class, TlsContextFactory.class);
            MatcherAssert.assertThat((Object)method, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            MatcherAssert.assertThat((Object)method.getName(), (Matcher)CoreMatchers.is((Object)"getSecureConnectionIfPossible"));
        }
        catch (NoSuchMethodException e) {
            MatcherAssert.assertThat((String)"Method should exist", (boolean)false);
        }
    }

    @Test
    public void testGetSecureConnectionWithNullDataSource() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        try {
            wrapper.getSecureConnectionIfPossible("user", "password", null, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithMockDataSource() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("user", "password", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithNullUserAndPassword() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible(null, null, mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithEmptyUserAndPassword() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("", "", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithNullUserAndValidPassword() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible(null, "password", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithValidUserAndNullPassword() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("user", null, mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithEmptyUserAndValidPassword() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("", "password", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithValidUserAndEmptyPassword() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("user", "", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithWhitespaceUserAndPassword() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("   ", "   ", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithSpecialCharactersInCredentials() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("user@domain.com", "pass@word123!", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithUnicodeCharactersInCredentials() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("Jos\u00e9", "Caf\u00e9123", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithVeryLongCredentials() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        String longUser = new String(new char[1000]).replace("\u0000", "a");
        String longPassword = new String(new char[1000]).replace("\u0000", "b");
        try {
            wrapper.getSecureConnectionIfPossible(longUser, longPassword, mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionWithNullTlsContextFactory() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("user", "password", mockDataSource, null);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetSecureConnectionMethodIsSynchronized() throws Exception {
        Method method = AbstractDataSourceWrapper.class.getDeclaredMethod("getSecureConnectionIfPossible", String.class, String.class, StandardDataSource.class, TlsContextFactory.class);
        Assert.assertTrue((boolean)Modifier.isSynchronized(method.getModifiers()));
    }

    @Test
    public void testGetSecureConnectionMethodThrowsSQLException() throws Exception {
        Method method = AbstractDataSourceWrapper.class.getDeclaredMethod("getSecureConnectionIfPossible", String.class, String.class, StandardDataSource.class, TlsContextFactory.class);
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        boolean throwsSQLException = false;
        for (Class<?> exceptionType : exceptionTypes) {
            if (!exceptionType.equals(SQLException.class)) continue;
            throwsSQLException = true;
            break;
        }
        Assert.assertTrue((String)"getSecureConnectionIfPossible method should throw SQLException", (boolean)throwsSQLException);
    }

    @Test
    public void testGetSecureConnectionMethodReturnsConnection() throws Exception {
        Method method = AbstractDataSourceWrapper.class.getDeclaredMethod("getSecureConnectionIfPossible", String.class, String.class, StandardDataSource.class, TlsContextFactory.class);
        Assert.assertEquals(Connection.class, method.getReturnType());
    }

    @Test
    public void testClassHasCorrectPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.connection.enhydra.wrappers", (Object)AbstractDataSourceWrapper.class.getPackage().getName());
    }

    @Test
    public void testClassHasCorrectName() {
        Assert.assertEquals((Object)"AbstractDataSourceWrapper", (Object)AbstractDataSourceWrapper.class.getSimpleName());
    }

    @Test
    public void testClassHasLogger() {
        try {
            Field loggerField = AbstractDataSourceWrapper.class.getDeclaredField("LOGGER");
            Assert.assertTrue((boolean)Modifier.isStatic(loggerField.getModifiers()));
            Assert.assertTrue((boolean)Modifier.isFinal(loggerField.getModifiers()));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)"LOGGER field should exist");
        }
    }

    @Test
    public void testClassHasCorrectImports() {
        String className = AbstractDataSourceWrapper.class.getName();
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.connection.enhydra.wrappers.AbstractDataSourceWrapper", (Object)className);
    }

    @Test
    public void testClassExtendsObject() {
        Assert.assertEquals(Object.class, AbstractDataSourceWrapper.class.getSuperclass());
    }

    @Test
    public void testClassIsPublic() {
        Assert.assertTrue((boolean)Modifier.isPublic(AbstractDataSourceWrapper.class.getModifiers()));
    }

    @Test
    public void testClassIsNotAbstract() {
        Assert.assertFalse((boolean)Modifier.isAbstract(AbstractDataSourceWrapper.class.getModifiers()));
    }

    @Test
    public void testClassIsNotFinal() {
        Assert.assertFalse((boolean)Modifier.isFinal(AbstractDataSourceWrapper.class.getModifiers()));
    }

    @Test
    public void testConstructorIsPublic() throws Exception {
        Constructor constructor = AbstractDataSourceWrapper.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPublic(constructor.getModifiers()));
    }

    @Test
    public void testConstructorTakesNoParameters() throws Exception {
        Constructor constructor = AbstractDataSourceWrapper.class.getDeclaredConstructor(new Class[0]);
        Assert.assertEquals((long)0L, (long)constructor.getParameterCount());
    }

    @Test
    public void testMethodParameterCount() throws Exception {
        Method method = AbstractDataSourceWrapper.class.getDeclaredMethod("getSecureConnectionIfPossible", String.class, String.class, StandardDataSource.class, TlsContextFactory.class);
        Assert.assertEquals((long)4L, (long)method.getParameterCount());
    }

    @Test
    public void testMethodParameterTypes() throws Exception {
        Method method = AbstractDataSourceWrapper.class.getDeclaredMethod("getSecureConnectionIfPossible", String.class, String.class, StandardDataSource.class, TlsContextFactory.class);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Assert.assertEquals(String.class, parameterTypes[0]);
        Assert.assertEquals(String.class, parameterTypes[1]);
        Assert.assertEquals(StandardDataSource.class, parameterTypes[2]);
        Assert.assertEquals(TlsContextFactory.class, parameterTypes[3]);
    }

    @Test
    public void testMethodIsPublic() throws Exception {
        Method method = AbstractDataSourceWrapper.class.getDeclaredMethod("getSecureConnectionIfPossible", String.class, String.class, StandardDataSource.class, TlsContextFactory.class);
        Assert.assertTrue((boolean)Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void testMultipleInstancesAreIndependent() {
        AbstractDataSourceWrapper wrapper1 = new AbstractDataSourceWrapper();
        AbstractDataSourceWrapper wrapper2 = new AbstractDataSourceWrapper();
        Assert.assertNotNull((Object)wrapper1);
        Assert.assertNotNull((Object)wrapper2);
        Assert.assertNotSame((Object)wrapper1, (Object)wrapper2);
    }

    @Test
    public void testInstanceCanBeReused() {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        try {
            wrapper.getSecureConnectionIfPossible("user1", "password1", mockDataSource, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            wrapper.getSecureConnectionIfPossible("user2", "password2", mockDataSource, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testThreadSafety() throws InterruptedException {
        AbstractDataSourceWrapper wrapper = new AbstractDataSourceWrapper();
        StandardDataSource mockDataSource = new StandardDataSource();
        Thread[] threads = new Thread[5];
        for (int i = 0; i < threads.length; ++i) {
            int threadId = i;
            threads[i] = new Thread(() -> {
                try {
                    wrapper.getSecureConnectionIfPossible("user" + threadId, "password" + threadId, mockDataSource, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join(1000L);
        }
    }
}

