/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import com.github.benmanes.caffeine.cache.Policy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.api.config.DbPoolingProfile;
import org.mule.db.commons.api.exception.connection.ConnectionCommitException;
import org.mule.db.commons.api.param.ColumnType;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.DbConnectionProvider;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.connection.JdbcConnectionFactory;
import org.mule.db.commons.internal.domain.type.ArrayResolvedDbType;
import org.mule.db.commons.internal.domain.type.ClobResolvedDataType;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.MappedStructResolvedDbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.domain.type.StructDbType;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tx.DataSourceDecorator;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.api.util.collection.Collectors;

@RunWith(value=MockitoJUnitRunner.class)
public class DbConnectionProviderTestCase {
    @Mock
    private Registry mockRegistry;
    @Mock
    private DataSource mockDataSource;
    @Mock
    private Connection mockConnection;
    @Mock
    private DbConnection mockDbConnection;
    @Mock
    private DbPoolingProfile mockPoolingProfile;
    @Mock
    private DataSourceDecorator mockDataSourceDecorator;
    @Mock
    private XAConnection mockXaConnection;
    @Mock
    private MuleXaObject mockMuleXaObject;
    private TestDbConnectionProvider provider;
    private List<ColumnType> columnTypes;

    @Before
    public void setUp() {
        this.provider = new TestDbConnectionProvider();
        this.provider.setRegistry(this.mockRegistry);
        this.columnTypes = new ArrayList<ColumnType>();
    }

    @Test
    public void testDefaultConstructor() {
        TestDbConnectionProvider defaultProvider = new TestDbConnectionProvider();
        Assert.assertNotNull((Object)((Object)defaultProvider));
    }

    @Test
    public void testParameterizedConstructor() {
        TestDbConnectionProvider paramProvider = new TestDbConnectionProvider("testConfig", this.mockRegistry, this.mockPoolingProfile, this.columnTypes);
        Assert.assertNotNull((Object)((Object)paramProvider));
    }

    @Test
    public void testParameterizedConstructorWithCacheSize() {
        TestDbConnectionProvider paramProvider = new TestDbConnectionProvider("testConfig", this.mockRegistry, this.mockPoolingProfile, this.columnTypes, 100L);
        Assert.assertNotNull((Object)((Object)paramProvider));
    }

    @Test
    public void testCreateJdbcConnectionFactory() {
        JdbcConnectionFactory factory = this.provider.createJdbcConnectionFactory();
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testValidate() {
        ConnectionValidationResult result = this.provider.validate(this.mockDbConnection);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isValid());
    }

    @Test
    public void testResolveCustomTypesWithEmptyList() {
        List<DbType> result = this.provider.resolveCustomTypes();
        Assert.assertNotNull(result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testCreateDbConnection() throws Exception {
        DbConnection result = this.provider.createDbConnection(this.mockConnection);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultDbConnection));
    }

    @Test
    public void testClassHasCorrectPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.connection", (Object)DbConnectionProvider.class.getPackage().getName());
    }

    @Test
    public void testClassHasCorrectName() {
        Assert.assertEquals((Object)"DbConnectionProvider", (Object)DbConnectionProvider.class.getSimpleName());
    }

    @Test
    public void testClassIsAbstract() {
        Assert.assertTrue((boolean)Modifier.isAbstract(DbConnectionProvider.class.getModifiers()));
    }

    @Test
    public void testClassIsPublic() {
        Assert.assertTrue((boolean)Modifier.isPublic(DbConnectionProvider.class.getModifiers()));
    }

    @Test
    public void testClassImplementsConnectionProvider() {
        Assert.assertTrue((boolean)ConnectionProvider.class.isAssignableFrom(DbConnectionProvider.class));
    }

    @Test
    public void testClassImplementsInitialisable() {
        Assert.assertTrue((boolean)Initialisable.class.isAssignableFrom(DbConnectionProvider.class));
    }

    @Test
    public void testClassImplementsDisposable() {
        Assert.assertTrue((boolean)Disposable.class.isAssignableFrom(DbConnectionProvider.class));
    }

    @Test
    public void testDefaultConstructorIsPublic() throws Exception {
        Constructor constructor = DbConnectionProvider.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPublic(constructor.getModifiers()));
    }

    @Test
    public void testParameterizedConstructorIsPublic() throws Exception {
        Constructor constructor = DbConnectionProvider.class.getDeclaredConstructor(String.class, Registry.class, DbPoolingProfile.class, List.class);
        Assert.assertTrue((boolean)Modifier.isPublic(constructor.getModifiers()));
    }

    @Test
    public void testParameterizedConstructorWithCacheSizeIsPublic() throws Exception {
        Constructor constructor = DbConnectionProvider.class.getDeclaredConstructor(String.class, Registry.class, DbPoolingProfile.class, List.class, Long.TYPE);
        Assert.assertTrue((boolean)Modifier.isPublic(constructor.getModifiers()));
    }

    @Test
    public void testConnectMethodIsFinal() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("connect", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isFinal(method.getModifiers()));
    }

    @Test
    public void testDisconnectMethodIsFinal() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("disconnect", DbConnection.class);
        Assert.assertTrue((boolean)Modifier.isFinal(method.getModifiers()));
    }

    @Test
    public void testDisposeMethodIsFinal() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("dispose", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isFinal(method.getModifiers()));
    }

    @Test
    public void testGetDataSourceMethodIsAbstract() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("getDataSource", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isAbstract(method.getModifiers()));
    }

    @Test
    public void testGetDataSourceConfigMethodIsAbstract() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("getDataSourceConfig", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isAbstract(method.getModifiers()));
    }

    @Test
    public void testCreateJdbcConnectionFactoryMethodIsProtected() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("createJdbcConnectionFactory", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isProtected(method.getModifiers()));
    }

    @Test
    public void testGetDbVendorErrorTypeMethodIsProtected() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("getDbVendorErrorType", SQLException.class);
        Assert.assertTrue((boolean)Modifier.isProtected(method.getModifiers()));
    }

    @Test
    public void testCreateDbConnectionMethodIsProtected() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("createDbConnection", Connection.class);
        Assert.assertTrue((boolean)Modifier.isProtected(method.getModifiers()));
    }

    @Test
    public void testResolveCustomTypesMethodIsPublic() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("resolveCustomTypes", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void testGetConfiguredDataSourceMethodIsPublic() throws Exception {
        Method method = DbConnectionProvider.class.getDeclaredMethod("getConfiguredDataSource", new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void testConstants() {
        Assert.assertEquals((Object)"(.*)\\.jar", (Object)"(.*)\\.jar");
    }

    @Test
    public void testConstructorWithFourParameters() {
        String configName = "testConfig";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        DbPoolingProfile poolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        List columnTypes = Collections.emptyList();
        DbConnectionProvider provider = new DbConnectionProvider(configName, registry, poolingProfile, columnTypes){

            public Optional<DataSource> getDataSource() {
                return Optional.empty();
            }

            public Optional<DataSourceConfig> getDataSourceConfig() {
                return Optional.empty();
            }
        };
        Assert.assertNotNull((Object)provider);
    }

    @Test
    public void testConstructorWithFiveParameters() {
        String configName = "testConfig";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        DbPoolingProfile poolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        List columnTypes = Collections.emptyList();
        long cacheQueryTemplateSize = 100L;
        DbConnectionProvider provider = new DbConnectionProvider(configName, registry, poolingProfile, columnTypes, cacheQueryTemplateSize){

            public Optional<DataSource> getDataSource() {
                return Optional.empty();
            }

            public Optional<DataSourceConfig> getDataSourceConfig() {
                return Optional.empty();
            }
        };
        Assert.assertNotNull((Object)provider);
    }

    @Test
    public void testConstructorWithFiveParametersSetsCacheSize() throws InitialisationException {
        String configName = "testConfig";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        DbPoolingProfile poolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        List columnTypes = Collections.emptyList();
        long cacheQueryTemplateSize = 100L;
        final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        DbConnectionProvider provider = new DbConnectionProvider(configName, registry, poolingProfile, columnTypes, cacheQueryTemplateSize){

            public Optional<DataSource> getDataSource() {
                return Optional.of(dataSource);
            }

            public Optional<DataSourceConfig> getDataSourceConfig() {
                return Optional.empty();
            }
        };
        provider.initialise();
        Assert.assertEquals((long)cacheQueryTemplateSize, (long)((Policy.Eviction)provider.cachedTemplates.policy().eviction().get()).getMaximum());
    }

    @Test
    public void testConnectBasicFunctionality() throws Exception {
        this.provider.setDataSource(this.mockDataSource);
        Mockito.lenient().when((Object)this.mockRegistry.lookupAllByType(DataSourceDecorator.class)).thenReturn(new ArrayList());
        Mockito.lenient().when((Object)this.mockDataSource.getConnection()).thenReturn((Object)this.mockConnection);
        Mockito.lenient().when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        this.provider.initialise();
        DbConnection result = this.provider.connect();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultDbConnection));
    }

    @Test
    public void testDisconnectWithValidConnection() throws Exception {
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)true);
        this.provider.disconnect(this.mockDbConnection);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).release();
    }

    @Test
    public void testDisconnectWithAutoCommitFalse() throws Exception {
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)false);
        this.provider.disconnect(this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).commit();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).release();
    }

    @Test
    public void testDisconnectWithCommitException() throws Exception {
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)false);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Commit failed")}).when((Object)this.mockConnection)).commit();
        Assert.assertThrows(ConnectionCommitException.class, () -> this.provider.disconnect(this.mockDbConnection));
    }

    @Test
    public void testDisconnectWithClosedException() throws Exception {
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)true);
        this.provider.disconnect(this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).commit();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection, (VerificationMode)Mockito.never())).release();
    }

    @Test
    public void testDisconnectWithReleaseException() throws Exception {
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)true);
        ((DbConnection)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Release failed")}).when((Object)this.mockDbConnection)).release();
        Assert.assertThrows(RuntimeException.class, () -> this.provider.disconnect(this.mockDbConnection));
    }

    @Test
    public void testInitialiseWithDataSource() throws Exception {
        this.provider.setDataSource(this.mockDataSource);
        Mockito.when((Object)this.mockRegistry.lookupAllByType(DataSourceDecorator.class)).thenReturn(new ArrayList());
        this.provider.initialise();
        Assert.assertNotNull((Object)this.provider.getConfiguredDataSource());
    }

    @Test
    public void testInitialiseWithDataSourceConfig() throws Exception {
        DataSourceConfig mockConfig = (DataSourceConfig)Mockito.mock(DataSourceConfig.class);
        this.provider.setDataSourceConfig(mockConfig);
        Assert.assertNotNull(this.provider.getDataSourceConfig());
        Assert.assertTrue((boolean)this.provider.getDataSourceConfig().isPresent());
    }

    @Test
    public void testInitialiseWithException() throws Exception {
        this.provider.setDataSource(this.mockDataSource);
        Mockito.when((Object)this.mockRegistry.lookupAllByType(DataSourceDecorator.class)).thenThrow(new Throwable[]{new RuntimeException("DataSource creation failed")});
        Assert.assertThrows(RuntimeException.class, () -> this.provider.initialise());
    }

    @Test
    public void testInitialiseWithNoDataSourceOrConfig() throws Exception {
        Mockito.when((Object)this.mockRegistry.lookupAllByType(DataSourceDecorator.class)).thenReturn(new ArrayList());
        Assert.assertThrows(MuleRuntimeException.class, () -> this.provider.initialise());
    }

    @Test
    public void testDispose() throws Exception {
        this.provider.setDataSource(this.mockDataSource);
        Mockito.when((Object)this.mockRegistry.lookupAllByType(DataSourceDecorator.class)).thenReturn(new ArrayList());
        this.provider.initialise();
        this.provider.dispose();
    }

    @Test
    public void testResolveCustomTypesWithArrayType() {
        ColumnType arrayType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)arrayType.getId()).thenReturn((Object)2003);
        Mockito.when((Object)arrayType.getTypeName()).thenReturn((Object)"ARRAY_TYPE");
        this.provider.setColumnTypes(Collections.singletonList(arrayType));
        List<DbType> result = this.provider.resolveCustomTypes();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof ArrayResolvedDbType));
        Assert.assertEquals((Object)"ARRAY_TYPE", (Object)result.get(0).getName());
    }

    @Test
    public void testResolveCustomTypesWithStructType() {
        ColumnType structType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)structType.getId()).thenReturn((Object)2002);
        Mockito.when((Object)structType.getTypeName()).thenReturn((Object)"STRUCT_TYPE");
        Mockito.when((Object)structType.getClassName()).thenReturn((Object)"");
        this.provider.setColumnTypes(Collections.singletonList(structType));
        List<DbType> result = this.provider.resolveCustomTypes();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof StructDbType));
        Assert.assertEquals((Object)"STRUCT_TYPE", (Object)result.get(0).getName());
    }

    @Test
    public void testResolveCustomTypesWithMappedStructType() {
        ColumnType structType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)structType.getId()).thenReturn((Object)2002);
        Mockito.when((Object)structType.getTypeName()).thenReturn((Object)"MAPPED_STRUCT_TYPE");
        Mockito.when((Object)structType.getClassName()).thenReturn((Object)"java.lang.String");
        this.provider.setColumnTypes(Collections.singletonList(structType));
        List<DbType> result = this.provider.resolveCustomTypes();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof MappedStructResolvedDbType));
        Assert.assertEquals((Object)"MAPPED_STRUCT_TYPE", (Object)result.get(0).getName());
    }

    @Test
    public void testResolveCustomTypesWithInvalidClassName() {
        ColumnType structType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)structType.getId()).thenReturn((Object)2002);
        Mockito.when((Object)structType.getTypeName()).thenReturn((Object)"INVALID_STRUCT_TYPE");
        Mockito.when((Object)structType.getClassName()).thenReturn((Object)"com.invalid.ClassName");
        this.provider.setColumnTypes(Collections.singletonList(structType));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.provider.resolveCustomTypes());
    }

    @Test
    public void testResolveCustomTypesWithClobType() {
        ColumnType clobType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)clobType.getId()).thenReturn((Object)2005);
        Mockito.when((Object)clobType.getTypeName()).thenReturn((Object)"CLOB_TYPE");
        this.provider.setColumnTypes(Collections.singletonList(clobType));
        List<DbType> result = this.provider.resolveCustomTypes();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof ClobResolvedDataType));
        Assert.assertEquals((Object)"CLOB_TYPE", (Object)result.get(0).getName());
    }

    @Test
    public void testResolveCustomTypesWithGenericType() {
        ColumnType genericType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)genericType.getId()).thenReturn((Object)12);
        Mockito.when((Object)genericType.getTypeName()).thenReturn((Object)"GENERIC_TYPE");
        this.provider.setColumnTypes(Collections.singletonList(genericType));
        List<DbType> result = this.provider.resolveCustomTypes();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof ResolvedDbType));
        Assert.assertEquals((Object)"GENERIC_TYPE", (Object)result.get(0).getName());
    }

    @Test
    public void testResolveCustomTypesWithMultipleTypes() {
        ColumnType arrayType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)arrayType.getId()).thenReturn((Object)2003);
        Mockito.when((Object)arrayType.getTypeName()).thenReturn((Object)"ARRAY_TYPE");
        ColumnType structType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)structType.getId()).thenReturn((Object)2002);
        Mockito.when((Object)structType.getTypeName()).thenReturn((Object)"STRUCT_TYPE");
        Mockito.when((Object)structType.getClassName()).thenReturn((Object)"");
        ColumnType clobType = (ColumnType)Mockito.mock(ColumnType.class);
        Mockito.when((Object)clobType.getId()).thenReturn((Object)2005);
        Mockito.when((Object)clobType.getTypeName()).thenReturn((Object)"CLOB_TYPE");
        List<ColumnType> types = Arrays.asList(arrayType, structType, clobType);
        this.provider.setColumnTypes(types);
        List<DbType> result = this.provider.resolveCustomTypes();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof ArrayResolvedDbType));
        Assert.assertTrue((boolean)(result.get(1) instanceof StructDbType));
        Assert.assertTrue((boolean)(result.get(2) instanceof ClobResolvedDataType));
    }

    @Test
    public void testGetConfiguredDataSource() throws Exception {
        this.provider.setDataSource(this.mockDataSource);
        Mockito.when((Object)this.mockRegistry.lookupAllByType(DataSourceDecorator.class)).thenReturn(new ArrayList());
        this.provider.initialise();
        DataSource result = this.provider.getConfiguredDataSource();
        Assert.assertNotNull((Object)result);
    }

    private static class TestDbConnectionProvider
    extends DbConnectionProvider {
        private DataSource testDataSource;
        private DataSourceConfig testDataSourceConfig;
        private List<? extends ColumnType> testColumnTypes = new ArrayList<ColumnType>();
        private Registry testRegistry;

        public TestDbConnectionProvider() {
        }

        public TestDbConnectionProvider(String configName, Registry registry, DbPoolingProfile poolingProfile, List<? extends ColumnType> columnTypes) {
            super(configName, registry, poolingProfile, columnTypes);
            this.testRegistry = registry;
        }

        public TestDbConnectionProvider(String configName, Registry registry, DbPoolingProfile poolingProfile, List<? extends ColumnType> columnTypes, long cacheQueryTemplateSize) {
            super(configName, registry, poolingProfile, columnTypes, cacheQueryTemplateSize);
            this.testRegistry = registry;
        }

        public Optional<DataSource> getDataSource() {
            return Optional.ofNullable(this.testDataSource);
        }

        public Optional<DataSourceConfig> getDataSourceConfig() {
            return Optional.ofNullable(this.testDataSourceConfig);
        }

        public void setDataSource(DataSource dataSource) {
            this.testDataSource = dataSource;
        }

        public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
            this.testDataSourceConfig = dataSourceConfig;
        }

        public void setColumnTypes(List<? extends ColumnType> columnTypes) {
            this.testColumnTypes = columnTypes;
        }

        public void setRegistry(Registry registry) {
            this.testRegistry = registry;
        }

        public void initialise() throws InitialisationException {
            try {
                Field registryField = DbConnectionProvider.class.getDeclaredField("registry");
                registryField.setAccessible(true);
                registryField.set((Object)this, this.testRegistry);
            }
            catch (Exception e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Failed to set registry"), (Throwable)e, (Initialisable)this);
            }
            super.initialise();
        }

        public List<DbType> resolveCustomTypes() {
            return (List)this.testColumnTypes.stream().map(type -> {
                String name = type.getTypeName();
                int id = type.getId();
                if (id == 2003) {
                    return new ArrayResolvedDbType(id, name);
                }
                if (id == 2002) {
                    String className = type.getClassName();
                    if (!StringUtils.isEmpty((CharSequence)className)) {
                        Class<?> mappedClass;
                        try {
                            mappedClass = Class.forName(className);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Cannot find mapped class: " + className);
                        }
                        return new MappedStructResolvedDbType(id, name, mappedClass);
                    }
                    return new StructDbType(id, name);
                }
                if (id == 2005) {
                    return new ClobResolvedDataType(id, name);
                }
                return new ResolvedDbType(id, name);
            }).collect(Collectors.toImmutableList());
        }
    }
}

