/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.config.DbPoolingProfile;
import org.mule.db.commons.api.param.TransactionIsolation;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.DataSourceFactory;
import org.mule.runtime.api.config.DatabasePoolingProfile;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.tx.DataSourceDecorator;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DataSourceFactoryTestCase
extends AbstractMuleTestCase {
    private DataSourceFactory dataSourceFactory;
    private DataSourceConfig mockDataSourceConfig;
    private DbPoolingProfile mockPoolingProfile;
    private DataSourceDecorator mockDataSourceDecorator;

    @Before
    public void setUp() {
        this.mockDataSourceConfig = (DataSourceConfig)Mockito.mock(DataSourceConfig.class);
        this.mockPoolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        this.mockDataSourceDecorator = (DataSourceDecorator)Mockito.mock(DataSourceDecorator.class);
        this.dataSourceFactory = new DataSourceFactory("testFactory", Arrays.asList(this.mockDataSourceDecorator));
    }

    @Test
    public void testConstructorWithValidParameters() {
        MatcherAssert.assertThat((Object)this.dataSourceFactory, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreateWithNullPoolingProfile() throws SQLException {
        Mockito.when((Object)this.mockDataSourceConfig.isUseXaTransactions()).thenReturn((Object)false);
        Mockito.when((Object)this.mockDataSourceConfig.getDriverClassName()).thenReturn((Object)"com.mysql.jdbc.Driver");
        Mockito.when((Object)this.mockDataSourceConfig.getPassword()).thenReturn((Object)"password");
        Mockito.when((Object)this.mockDataSourceConfig.getTransactionIsolation()).thenReturn((Object)TransactionIsolation.READ_COMMITTED);
        Mockito.when((Object)this.mockDataSourceConfig.getUrl()).thenReturn((Object)"jdbc:mysql://localhost:3306/test");
        Mockito.when((Object)this.mockDataSourceConfig.getUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.mockDataSourceConfig.getTlsContextFactory()).thenReturn(Optional.empty());
        DataSource result = this.dataSourceFactory.create(this.mockDataSourceConfig, null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreateWithPoolingProfile() throws SQLException {
        Mockito.when((Object)this.mockDataSourceConfig.isUseXaTransactions()).thenReturn((Object)false);
        Mockito.when((Object)this.mockDataSourceConfig.getDriverClassName()).thenReturn((Object)"com.mysql.jdbc.Driver");
        Mockito.when((Object)this.mockDataSourceConfig.getPassword()).thenReturn((Object)"password");
        Mockito.when((Object)this.mockDataSourceConfig.getTransactionIsolation()).thenReturn((Object)TransactionIsolation.READ_COMMITTED);
        Mockito.when((Object)this.mockDataSourceConfig.getUrl()).thenReturn((Object)"jdbc:mysql://localhost:3306/test");
        Mockito.when((Object)this.mockDataSourceConfig.getUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.mockDataSourceConfig.getTlsContextFactory()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockPoolingProfile.getMaxPoolSize()).thenReturn((Object)10);
        Mockito.when((Object)this.mockPoolingProfile.getMinPoolSize()).thenReturn((Object)5);
        Mockito.when((Object)this.mockPoolingProfile.getMaxWait()).thenReturn((Object)30);
        Mockito.when((Object)((Object)this.mockPoolingProfile.getMaxWaitUnit())).thenReturn((Object)TimeUnit.SECONDS);
        Mockito.when((Object)this.mockPoolingProfile.getAcquireIncrement()).thenReturn((Object)3);
        Mockito.when((Object)this.mockPoolingProfile.getMaxStatements()).thenReturn((Object)100);
        Mockito.when((Object)this.mockPoolingProfile.getMaxIdleTime()).thenReturn((Object)300);
        Mockito.when((Object)this.mockPoolingProfile.getTestConnectionOnCheckout()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPoolingProfile.getPreparedStatementCacheSize()).thenReturn((Object)50);
        Mockito.when((Object)this.mockPoolingProfile.getAdditionalProperties()).thenReturn(new HashMap());
        DataSource result = this.dataSourceFactory.create(this.mockDataSourceConfig, this.mockPoolingProfile);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreateWithXaTransactions() throws SQLException {
        Mockito.when((Object)this.mockDataSourceConfig.isUseXaTransactions()).thenReturn((Object)true);
        Mockito.when((Object)this.mockDataSourceConfig.getDriverClassName()).thenReturn((Object)"com.mysql.jdbc.Driver");
        Mockito.when((Object)this.mockDataSourceConfig.getPassword()).thenReturn((Object)"password");
        Mockito.when((Object)this.mockDataSourceConfig.getTransactionIsolation()).thenReturn((Object)TransactionIsolation.READ_COMMITTED);
        Mockito.when((Object)this.mockDataSourceConfig.getUrl()).thenReturn((Object)"jdbc:mysql://localhost:3306/test");
        Mockito.when((Object)this.mockDataSourceConfig.getUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.mockDataSourceConfig.getTlsContextFactory()).thenReturn(Optional.empty());
        DataSource result = this.dataSourceFactory.create(this.mockDataSourceConfig, null);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreateWithXaTransactionsAndPoolingProfile() throws SQLException {
        Mockito.when((Object)this.mockDataSourceConfig.isUseXaTransactions()).thenReturn((Object)true);
        Mockito.when((Object)this.mockDataSourceConfig.getDriverClassName()).thenReturn((Object)"com.mysql.jdbc.Driver");
        Mockito.when((Object)this.mockDataSourceConfig.getPassword()).thenReturn((Object)"password");
        Mockito.when((Object)this.mockDataSourceConfig.getTransactionIsolation()).thenReturn((Object)TransactionIsolation.READ_COMMITTED);
        Mockito.when((Object)this.mockDataSourceConfig.getUrl()).thenReturn((Object)"jdbc:mysql://localhost:3306/test");
        Mockito.when((Object)this.mockDataSourceConfig.getUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.mockDataSourceConfig.getTlsContextFactory()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockPoolingProfile.getMaxPoolSize()).thenReturn((Object)10);
        Mockito.when((Object)this.mockPoolingProfile.getMinPoolSize()).thenReturn((Object)5);
        Mockito.when((Object)this.mockPoolingProfile.getMaxWait()).thenReturn((Object)30);
        Mockito.when((Object)((Object)this.mockPoolingProfile.getMaxWaitUnit())).thenReturn((Object)TimeUnit.SECONDS);
        Mockito.when((Object)this.mockPoolingProfile.getAcquireIncrement()).thenReturn((Object)3);
        Mockito.when((Object)this.mockPoolingProfile.getMaxStatements()).thenReturn((Object)100);
        Mockito.when((Object)this.mockPoolingProfile.getMaxIdleTime()).thenReturn((Object)300);
        Mockito.when((Object)this.mockPoolingProfile.getTestConnectionOnCheckout()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPoolingProfile.getPreparedStatementCacheSize()).thenReturn((Object)50);
        Mockito.when((Object)this.mockPoolingProfile.getAdditionalProperties()).thenReturn(new HashMap());
        DataSource result = this.dataSourceFactory.create(this.mockDataSourceConfig, this.mockPoolingProfile);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testDecorateDataSource() {
        DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        DatabasePoolingProfile mockDatabasePoolingProfile = (DatabasePoolingProfile)Mockito.mock(DatabasePoolingProfile.class);
        DataSource result = this.dataSourceFactory.decorateDataSource(mockDataSource, mockDatabasePoolingProfile);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreatePooledDataSourceWithXaTransactions() throws SQLException {
        Mockito.when((Object)this.mockDataSourceConfig.isUseXaTransactions()).thenReturn((Object)true);
        Mockito.when((Object)this.mockDataSourceConfig.getDriverClassName()).thenReturn((Object)"com.mysql.jdbc.Driver");
        Mockito.when((Object)this.mockDataSourceConfig.getPassword()).thenReturn((Object)"password");
        Mockito.when((Object)this.mockDataSourceConfig.getTransactionIsolation()).thenReturn((Object)TransactionIsolation.READ_COMMITTED);
        Mockito.when((Object)this.mockDataSourceConfig.getUrl()).thenReturn((Object)"jdbc:mysql://localhost:3306/test");
        Mockito.when((Object)this.mockDataSourceConfig.getUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.mockDataSourceConfig.getTlsContextFactory()).thenReturn(Optional.empty());
        DataSource result = this.dataSourceFactory.createPooledDataSource(this.mockDataSourceConfig, this.mockPoolingProfile);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreatePooledDataSourceWithoutXaTransactions() throws SQLException {
        Mockito.when((Object)this.mockDataSourceConfig.isUseXaTransactions()).thenReturn((Object)false);
        Mockito.when((Object)this.mockDataSourceConfig.getDriverClassName()).thenReturn((Object)"com.mysql.jdbc.Driver");
        Mockito.when((Object)this.mockDataSourceConfig.getPassword()).thenReturn((Object)"password");
        Mockito.when((Object)this.mockDataSourceConfig.getTransactionIsolation()).thenReturn((Object)TransactionIsolation.READ_COMMITTED);
        Mockito.when((Object)this.mockDataSourceConfig.getUrl()).thenReturn((Object)"jdbc:mysql://localhost:3306/test");
        Mockito.when((Object)this.mockDataSourceConfig.getUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.mockDataSourceConfig.getTlsContextFactory()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockPoolingProfile.getMaxPoolSize()).thenReturn((Object)10);
        Mockito.when((Object)this.mockPoolingProfile.getMinPoolSize()).thenReturn((Object)5);
        Mockito.when((Object)this.mockPoolingProfile.getMaxWait()).thenReturn((Object)30);
        Mockito.when((Object)((Object)this.mockPoolingProfile.getMaxWaitUnit())).thenReturn((Object)TimeUnit.SECONDS);
        Mockito.when((Object)this.mockPoolingProfile.getAcquireIncrement()).thenReturn((Object)3);
        Mockito.when((Object)this.mockPoolingProfile.getMaxStatements()).thenReturn((Object)100);
        Mockito.when((Object)this.mockPoolingProfile.getMaxIdleTime()).thenReturn((Object)300);
        Mockito.when((Object)this.mockPoolingProfile.getTestConnectionOnCheckout()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPoolingProfile.getPreparedStatementCacheSize()).thenReturn((Object)50);
        Mockito.when((Object)this.mockPoolingProfile.getAdditionalProperties()).thenReturn(new HashMap());
        DataSource result = this.dataSourceFactory.createPooledDataSource(this.mockDataSourceConfig, this.mockPoolingProfile);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreatePooledStandardDataSourceWithAdditionalProperties() throws SQLException {
        DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("testProperty", "testValue");
        additionalProperties.put("maxPoolSize", "20");
        Mockito.when((Object)this.mockPoolingProfile.getMaxPoolSize()).thenReturn((Object)10);
        Mockito.when((Object)this.mockPoolingProfile.getMinPoolSize()).thenReturn((Object)5);
        Mockito.when((Object)this.mockPoolingProfile.getMaxWait()).thenReturn((Object)30);
        Mockito.when((Object)((Object)this.mockPoolingProfile.getMaxWaitUnit())).thenReturn((Object)TimeUnit.SECONDS);
        Mockito.when((Object)this.mockPoolingProfile.getAcquireIncrement()).thenReturn((Object)3);
        Mockito.when((Object)this.mockPoolingProfile.getMaxStatements()).thenReturn((Object)100);
        Mockito.when((Object)this.mockPoolingProfile.getMaxIdleTime()).thenReturn((Object)300);
        Mockito.when((Object)this.mockPoolingProfile.getTestConnectionOnCheckout()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPoolingProfile.getPreparedStatementCacheSize()).thenReturn((Object)50);
        Mockito.when((Object)this.mockPoolingProfile.getAdditionalProperties()).thenReturn(additionalProperties);
        DataSource result = this.dataSourceFactory.createPooledStandardDataSource(mockDataSource, this.mockPoolingProfile);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testDispose() {
        this.dataSourceFactory.dispose();
        MatcherAssert.assertThat((Object)this.dataSourceFactory, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.dataSourceFactory.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.connection"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.dataSourceFactory.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"DataSourceFactory"));
    }

    @Test
    public void testClassImplementsDisposable() {
        MatcherAssert.assertThat((Object)(this.dataSourceFactory instanceof Disposable), (Matcher)CoreMatchers.is((Object)true));
    }
}

