/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.api.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.config.DbPoolingProfile;

public class DbPoolingProfileTestCase {
    @Test
    public void testDefaultConstructor() {
        DbPoolingProfile profile = new DbPoolingProfile();
        Assert.assertEquals((long)5L, (long)profile.getMaxPoolSize());
        Assert.assertEquals((long)0L, (long)profile.getMinPoolSize());
        Assert.assertEquals((long)1L, (long)profile.getAcquireIncrement());
        Assert.assertEquals((long)5L, (long)profile.getPreparedStatementCacheSize());
        Assert.assertEquals((long)0L, (long)profile.getMaxWait());
        Assert.assertNull((Object)((Object)profile.getMaxWaitUnit()));
        Assert.assertEquals((long)0L, (long)profile.getMaxIdleTime());
        Assert.assertEquals((long)0L, (long)profile.getMaxStatements());
        Assert.assertFalse((boolean)profile.getTestConnectionOnCheckout());
        Assert.assertNotNull((Object)profile.getAdditionalProperties());
        Assert.assertTrue((boolean)profile.getAdditionalProperties().isEmpty());
    }

    @Test
    public void testConstructorWithParameters() {
        HashMap<String, String> additionalProps = new HashMap<String, String>();
        additionalProps.put("testKey", "testValue");
        DbPoolingProfile profile = new DbPoolingProfile(2, 10, 3, 8, 30, TimeUnit.MINUTES, 120, additionalProps);
        Assert.assertEquals((long)10L, (long)profile.getMaxPoolSize());
        Assert.assertEquals((long)2L, (long)profile.getMinPoolSize());
        Assert.assertEquals((long)3L, (long)profile.getAcquireIncrement());
        Assert.assertEquals((long)8L, (long)profile.getPreparedStatementCacheSize());
        Assert.assertEquals((long)30L, (long)profile.getMaxWait());
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)profile.getMaxWaitUnit()));
        Assert.assertEquals((long)120L, (long)profile.getMaxIdleTime());
        Assert.assertEquals((long)0L, (long)profile.getMaxStatements());
        Assert.assertTrue((boolean)profile.getTestConnectionOnCheckout());
        Assert.assertEquals(additionalProps, (Object)profile.getAdditionalProperties());
    }

    @Test
    public void testConstructorWithAllParameters() {
        HashMap<String, String> additionalProps = new HashMap<String, String>();
        additionalProps.put("testKey", "testValue");
        DbPoolingProfile profile = new DbPoolingProfile(2, 10, 3, 8, 30, TimeUnit.MINUTES, 120, 15, false, additionalProps);
        Assert.assertEquals((long)10L, (long)profile.getMaxPoolSize());
        Assert.assertEquals((long)2L, (long)profile.getMinPoolSize());
        Assert.assertEquals((long)3L, (long)profile.getAcquireIncrement());
        Assert.assertEquals((long)8L, (long)profile.getPreparedStatementCacheSize());
        Assert.assertEquals((long)30L, (long)profile.getMaxWait());
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)profile.getMaxWaitUnit()));
        Assert.assertEquals((long)120L, (long)profile.getMaxIdleTime());
        Assert.assertEquals((long)15L, (long)profile.getMaxStatements());
        Assert.assertFalse((boolean)profile.getTestConnectionOnCheckout());
        Assert.assertEquals(additionalProps, (Object)profile.getAdditionalProperties());
    }

    @Test
    public void testEqualsWithSameObject() {
        DbPoolingProfile profile = new DbPoolingProfile();
        Assert.assertTrue((boolean)profile.equals((Object)profile));
    }

    @Test
    public void testEqualsWithNull() {
        DbPoolingProfile profile = new DbPoolingProfile();
        Assert.assertFalse((boolean)profile.equals(null));
    }

    @Test
    public void testEqualsWithDifferentType() {
        DbPoolingProfile profile = new DbPoolingProfile();
        Assert.assertFalse((boolean)profile.equals((Object)"not a DbPoolingProfile"));
    }

    @Test
    public void testEqualsWithSameValues() {
        DbPoolingProfile profile1 = new DbPoolingProfile(1, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        DbPoolingProfile profile2 = new DbPoolingProfile(1, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        Assert.assertTrue((boolean)profile1.equals((Object)profile2));
        Assert.assertTrue((boolean)profile2.equals((Object)profile1));
    }

    @Test
    public void testEqualsWithDifferentValues() {
        DbPoolingProfile profile1 = new DbPoolingProfile(1, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        DbPoolingProfile profile2 = new DbPoolingProfile(2, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        Assert.assertFalse((boolean)profile1.equals((Object)profile2));
        Assert.assertFalse((boolean)profile2.equals((Object)profile1));
    }

    @Test
    public void testHashCode() {
        DbPoolingProfile profile1 = new DbPoolingProfile(1, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        DbPoolingProfile profile2 = new DbPoolingProfile(1, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        Assert.assertEquals((long)profile1.hashCode(), (long)profile2.hashCode());
    }

    @Test
    public void testHashCodeWithDifferentValues() {
        DbPoolingProfile profile1 = new DbPoolingProfile(1, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        DbPoolingProfile profile2 = new DbPoolingProfile(2, 5, 2, 3, 10, TimeUnit.SECONDS, 60, new HashMap());
        Assert.assertNotEquals((long)profile1.hashCode(), (long)profile2.hashCode());
    }

    @Test
    public void testAdditionalPropertiesModification() {
        HashMap<String, String> additionalProps = new HashMap<String, String>();
        additionalProps.put("testKey", "testValue");
        DbPoolingProfile profile = new DbPoolingProfile(1, 5, 2, 3, 10, TimeUnit.SECONDS, 60, additionalProps);
        Map returnedProps = profile.getAdditionalProperties();
        Assert.assertEquals(additionalProps, (Object)returnedProps);
        returnedProps.put("newKey", "newValue");
        Assert.assertEquals((long)2L, (long)profile.getAdditionalProperties().size());
        Assert.assertTrue((boolean)profile.getAdditionalProperties().containsKey("testKey"));
        Assert.assertTrue((boolean)profile.getAdditionalProperties().containsKey("newKey"));
    }

    @Test
    public void testEdgeCases() {
        DbPoolingProfile profile = new DbPoolingProfile(0, 0, 0, 0, 0, TimeUnit.MILLISECONDS, 0, new HashMap());
        Assert.assertEquals((long)0L, (long)profile.getMaxPoolSize());
        Assert.assertEquals((long)0L, (long)profile.getMinPoolSize());
        Assert.assertEquals((long)0L, (long)profile.getAcquireIncrement());
        Assert.assertEquals((long)0L, (long)profile.getPreparedStatementCacheSize());
        Assert.assertEquals((long)0L, (long)profile.getMaxWait());
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)profile.getMaxWaitUnit()));
        Assert.assertEquals((long)0L, (long)profile.getMaxIdleTime());
    }

    @Test
    public void testLargeValues() {
        DbPoolingProfile profile = new DbPoolingProfile(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, TimeUnit.DAYS, Integer.MAX_VALUE, new HashMap());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)profile.getMaxPoolSize());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)profile.getMinPoolSize());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)profile.getAcquireIncrement());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)profile.getPreparedStatementCacheSize());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)profile.getMaxWait());
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)profile.getMaxWaitUnit()));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)profile.getMaxIdleTime());
    }
}

