/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.api;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.StatementResult;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class StatementResultTestCase
extends AbstractMuleTestCase {
    private static final int TEST_AFFECTED_ROWS = 5;
    private static final BigInteger TEST_GENERATED_KEY = new BigInteger("123456789");

    @Test
    public void testConstructorWithValidParameters() {
        HashMap<String, BigInteger> generatedKeys = new HashMap<String, BigInteger>();
        generatedKeys.put("id", TEST_GENERATED_KEY);
        StatementResult result = new StatementResult(5, generatedKeys);
        Assert.assertEquals((long)5L, (long)result.getAffectedRows());
        Assert.assertEquals(generatedKeys, (Object)result.getGeneratedKeys());
    }

    @Test
    public void testConstructorWithNullGeneratedKeys() {
        StatementResult result = new StatementResult(5, null);
        Assert.assertEquals((long)5L, (long)result.getAffectedRows());
        MatcherAssert.assertThat((Object)result.getGeneratedKeys(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)result.getGeneratedKeys().isEmpty());
    }

    @Test
    public void testConstructorWithEmptyGeneratedKeys() {
        HashMap emptyKeys = new HashMap();
        StatementResult result = new StatementResult(5, emptyKeys);
        Assert.assertEquals((long)5L, (long)result.getAffectedRows());
        MatcherAssert.assertThat((Object)result.getGeneratedKeys(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)result.getGeneratedKeys().isEmpty());
    }

    @Test
    public void testConstructorWithZeroAffectedRows() {
        HashMap<String, BigInteger> generatedKeys = new HashMap<String, BigInteger>();
        generatedKeys.put("id", TEST_GENERATED_KEY);
        StatementResult result = new StatementResult(0, generatedKeys);
        Assert.assertEquals((long)0L, (long)result.getAffectedRows());
        Assert.assertEquals(generatedKeys, (Object)result.getGeneratedKeys());
    }

    @Test
    public void testConstructorWithNegativeAffectedRows() {
        HashMap<String, BigInteger> generatedKeys = new HashMap<String, BigInteger>();
        generatedKeys.put("id", TEST_GENERATED_KEY);
        StatementResult result = new StatementResult(-1, generatedKeys);
        Assert.assertEquals((long)-1L, (long)result.getAffectedRows());
        Assert.assertEquals(generatedKeys, (Object)result.getGeneratedKeys());
    }

    @Test
    public void testGetAffectedRows() {
        StatementResult result = new StatementResult(5, null);
        Assert.assertEquals((long)5L, (long)result.getAffectedRows());
    }

    @Test
    public void testGetGeneratedKeys() {
        HashMap<String, BigInteger> generatedKeys = new HashMap<String, BigInteger>();
        generatedKeys.put("id", TEST_GENERATED_KEY);
        generatedKeys.put("uuid", new BigInteger("987654321"));
        StatementResult result = new StatementResult(5, generatedKeys);
        Map returnedKeys = result.getGeneratedKeys();
        MatcherAssert.assertThat((Object)returnedKeys, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)2L, (long)returnedKeys.size());
        Assert.assertEquals((Object)TEST_GENERATED_KEY, returnedKeys.get("id"));
        Assert.assertEquals((Object)new BigInteger("987654321"), returnedKeys.get("uuid"));
    }

    @Test
    public void testGeneratedKeysAreImmutable() {
        HashMap<String, BigInteger> generatedKeys = new HashMap<String, BigInteger>();
        generatedKeys.put("id", TEST_GENERATED_KEY);
        StatementResult result = new StatementResult(5, generatedKeys);
        Map returnedKeys = result.getGeneratedKeys();
        Assert.assertThrows(UnsupportedOperationException.class, () -> returnedKeys.put("new_key", new BigInteger("999")));
    }

    @Test
    public void testGeneratedKeysAreDefensiveCopy() {
        HashMap<String, BigInteger> originalKeys = new HashMap<String, BigInteger>();
        originalKeys.put("id", TEST_GENERATED_KEY);
        StatementResult result = new StatementResult(5, originalKeys);
        originalKeys.put("modified_key", new BigInteger("999"));
        Map returnedKeys = result.getGeneratedKeys();
        Assert.assertEquals((long)1L, (long)returnedKeys.size());
        Assert.assertEquals((Object)TEST_GENERATED_KEY, returnedKeys.get("id"));
        Assert.assertFalse((boolean)returnedKeys.containsKey("modified_key"));
    }

    @Test
    public void testMultipleGeneratedKeys() {
        HashMap<String, BigInteger> generatedKeys = new HashMap<String, BigInteger>();
        generatedKeys.put("id", TEST_GENERATED_KEY);
        generatedKeys.put("sequence", new BigInteger("100"));
        generatedKeys.put("timestamp", new BigInteger("1234567890"));
        StatementResult result = new StatementResult(5, generatedKeys);
        Map returnedKeys = result.getGeneratedKeys();
        Assert.assertEquals((long)3L, (long)returnedKeys.size());
        Assert.assertEquals((Object)TEST_GENERATED_KEY, returnedKeys.get("id"));
        Assert.assertEquals((Object)new BigInteger("100"), returnedKeys.get("sequence"));
        Assert.assertEquals((Object)new BigInteger("1234567890"), returnedKeys.get("timestamp"));
    }

    @Test
    public void testLargeAffectedRows() {
        int largeAffectedRows = Integer.MAX_VALUE;
        StatementResult result = new StatementResult(largeAffectedRows, null);
        Assert.assertEquals((long)largeAffectedRows, (long)result.getAffectedRows());
    }

    @Test
    public void testLargeGeneratedKey() {
        HashMap<String, BigInteger> generatedKeys = new HashMap<String, BigInteger>();
        BigInteger largeKey = new BigInteger("9999999999999999999999999999999999999999");
        generatedKeys.put("large_id", largeKey);
        StatementResult result = new StatementResult(5, generatedKeys);
        Assert.assertEquals((Object)largeKey, result.getGeneratedKeys().get("large_id"));
    }
}

