/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.util.DefaultFileReader;
import org.mule.db.commons.internal.util.FileReader;

public class DefaultFileReaderTestCase {
    @Test
    public void testGetResourceAsStringWithValidResource() throws IOException {
        DefaultFileReader fileReader = new DefaultFileReader();
        String content = fileReader.getResourceAsString("test-resource.txt");
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((Object)"test content", (Object)content.trim());
    }

    @Test
    public void testGetResourceAsStringWithNonExistentResource() {
        DefaultFileReader fileReader = new DefaultFileReader();
        Assert.assertThrows(IOException.class, () -> fileReader.getResourceAsString("non-existent-resource.txt"));
    }

    @Test
    public void testGetResourceAsStringWithNullResource() {
        DefaultFileReader fileReader = new DefaultFileReader();
        Assert.assertThrows(IllegalArgumentException.class, () -> fileReader.getResourceAsString(null));
    }

    @Test
    public void testGetResourceAsStringWithEmptyResource() {
        DefaultFileReader fileReader = new DefaultFileReader();
        try {
            String string = fileReader.getResourceAsString("");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof IOException || e instanceof IllegalArgumentException ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDefaultFileReaderImplementsFileReader() {
        DefaultFileReader fileReader = new DefaultFileReader();
        Assert.assertTrue((boolean)(fileReader instanceof FileReader));
    }
}

