/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.util.CredentialsMaskUtils;

public class CredentialsMaskUtilsTestCase {
    @Test
    public void testMaskPasswordsWithUrlPattern() {
        String input = "url=\"jdbc:mysql://user:pass@localhost:3306/test\"";
        String result = CredentialsMaskUtils.maskPasswords((String)input);
        Assert.assertEquals((Object)"url=\"jdbc:mysql://user:pass@localhost:3306/test\"", (Object)result);
    }

    @Test
    public void testMaskPasswordsWithAddressPattern() {
        String input = "address=\"jdbc:postgresql://user:pass@localhost:5432/test\"";
        String result = CredentialsMaskUtils.maskPasswords((String)input);
        Assert.assertEquals((Object)"address=\"jdbc:postgresql://user:pass@localhost:5432/test\"", (Object)result);
    }

    @Test
    public void testMaskPasswordsWithPasswordPattern() {
        String input = "password=\"secretpassword\"";
        String result = CredentialsMaskUtils.maskPasswords((String)input);
        Assert.assertEquals((Object)"password=\"<<credentials>>\"", (Object)result);
    }

    @Test
    public void testMaskPasswordsWithMultiplePatterns() {
        String input = "url=\"jdbc:mysql://user:pass@localhost:3306/test\" password=\"secret\"";
        String result = CredentialsMaskUtils.maskPasswords((String)input);
        Assert.assertEquals((Object)"url=\"jdbc:mysql://user:pass@localhost:3306/test\" password=\"<<credentials>>\"", (Object)result);
    }

    @Test
    public void testMaskPasswordsWithNoCredentials() {
        String input = "jdbc:mysql://localhost:3306/test";
        String result = CredentialsMaskUtils.maskPasswords((String)input);
        Assert.assertEquals((Object)"jdbc:mysql://localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskPasswordsWithNullInput() {
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskPasswords(null));
    }

    @Test
    public void testMaskPasswordsWithEmptyInput() {
        String result = CredentialsMaskUtils.maskPasswords((String)"");
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testMaskUrlPasswordWithCustomPattern() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        String result = CredentialsMaskUtils.maskUrlPassword((String)input, (Pattern)pattern);
        Assert.assertEquals((Object)"jdbc:mysql://<<credentials>>@localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskUrlPasswordWithNoMatch() {
        String input = "jdbc:mysql://localhost:3306/test";
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        String result = CredentialsMaskUtils.maskUrlPassword((String)input, (Pattern)pattern);
        Assert.assertEquals((Object)"jdbc:mysql://localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskUrlPasswordWithNullInput() {
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskUrlPassword(null, (Pattern)pattern));
    }

    @Test
    public void testMaskUrlPasswordWithNullPattern() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskUrlPassword((String)input, null));
    }

    @Test
    public void testMaskUrlPasswordWithMask() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        String result = CredentialsMaskUtils.maskUrlPasswordWithMask((String)input, (Pattern)pattern, (String)"***MASKED***");
        Assert.assertEquals((Object)"jdbc:mysql://***MASKED***@localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskUrlUserAndPasswordWithPatterns() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Pattern passwordPattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        Pattern userPattern = Pattern.compile("user=([^&]*)");
        String result = CredentialsMaskUtils.maskUrlUserAndPassword((String)input, (Pattern)passwordPattern, (Pattern)userPattern);
        Assert.assertEquals((Object)"jdbc:mysql://<<credentials>>@localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskUrlUserAndPasswordWithUserInQuery() {
        String input = "jdbc:mysql://localhost:3306/test?user=myuser&password=mypass";
        Pattern passwordPattern = Pattern.compile("password=([^&]*)");
        Pattern userPattern = Pattern.compile("user=([^&]*)");
        String result = CredentialsMaskUtils.maskUrlUserAndPassword((String)input, (Pattern)passwordPattern, (Pattern)userPattern);
        Assert.assertEquals((Object)"jdbc:mysql://localhost:3306/test?user=<<user>>&password=<<credentials>>", (Object)result);
    }

    @Test
    public void testMaskUrlUserAndPasswordWithNullInput() {
        Pattern passwordPattern = Pattern.compile("password=([^&]*)");
        Pattern userPattern = Pattern.compile("user=([^&]*)");
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskUrlUserAndPassword(null, (Pattern)passwordPattern, (Pattern)userPattern));
    }

    @Test
    public void testMaskUrlUserAndPasswordWithNullPatterns() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskUrlUserAndPassword((String)input, null, null));
    }

    @Test
    public void testMaskUrlUserAndPasswordOverloaded() {
        String input = "jdbc:mysql://localhost:3306/test?user=myuser&password=mypass";
        String result = CredentialsMaskUtils.maskUrlUserAndPassword((String)input);
        Assert.assertEquals((Object)"jdbc:mysql://localhost:3306/test?user=<<user>>", (Object)result);
    }

    @Test
    public void testMaskUrlUserAndPasswordOverloadedWithQuotedPassword() {
        String input = "jdbc:mysql://localhost:3306/test?user=myuser&password=\"mypass\"";
        String result = CredentialsMaskUtils.maskUrlUserAndPassword((String)input);
        Assert.assertEquals((Object)"jdbc:mysql://localhost:3306/test?user=<<user>>", (Object)result);
    }

    @Test
    public void testMaskUrlUserAndPasswordOverloadedWithNoCredentials() {
        String input = "jdbc:mysql://localhost:3306/test";
        String result = CredentialsMaskUtils.maskUrlUserAndPassword((String)input);
        Assert.assertEquals((Object)"jdbc:mysql://localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskUrlUserAndPasswordOverloadedWithNullInput() {
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskUrlUserAndPassword(null));
    }

    @Test
    public void testMaskPasswordAttribute() {
        String result = CredentialsMaskUtils.maskPasswordAttribute((String)"secretpass");
        Assert.assertEquals((Object)"password=\"secretpass\"", (Object)result);
    }

    @Test
    public void testMaskPasswordAttributeWithNull() {
        String result = CredentialsMaskUtils.maskPasswordAttribute(null);
        Assert.assertEquals((Object)"password=\"null\"", (Object)result);
    }

    @Test
    public void testMaskPasswordAttributeWithEmpty() {
        String result = CredentialsMaskUtils.maskPasswordAttribute((String)"");
        Assert.assertEquals((Object)"password=\"\"", (Object)result);
    }

    @Test
    public void testConstants() {
        Assert.assertNotNull((Object)CredentialsMaskUtils.BARE_URL_PASSWORD_PATTERN);
        Assert.assertNotNull((Object)CredentialsMaskUtils.BARE_URL_PATTERN);
        Assert.assertNotNull((Object)CredentialsMaskUtils.URL_PATTERN);
        Assert.assertNotNull((Object)CredentialsMaskUtils.ADDRESS_PATTERN);
        Assert.assertNotNull((Object)CredentialsMaskUtils.PASSWORD_PATTERN);
        Assert.assertNotNull((Object)CredentialsMaskUtils.PASSWORD_PATTERN_NO_QUOTES);
        Assert.assertNotNull((Object)CredentialsMaskUtils.USER_PATTERN_NO_QUOTES);
        Assert.assertEquals((Object)"<<credentials>>", (Object)"<<credentials>>");
        Assert.assertEquals((Object)"<<user>>", (Object)"<<user>>");
        Assert.assertEquals((Object)"password=\"%s\"", (Object)"password=\"%s\"");
    }

    @Test
    public void testMaskUrlPatternWithPrefix() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        String result = CredentialsMaskUtils.maskUrlPattern((String)input, (Pattern)pattern, (String)"***MASKED***", (String)"prefix");
        Assert.assertEquals((Object)"jdbc:mysql://***MASKED***@localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskUrlPatternWithNoMatch() {
        String input = "jdbc:mysql://localhost:3306/test";
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        String result = CredentialsMaskUtils.maskUrlPattern((String)input, (Pattern)pattern, (String)"***MASKED***", (String)"prefix");
        Assert.assertEquals((Object)"jdbc:mysql://localhost:3306/test", (Object)result);
    }

    @Test
    public void testMaskUrlPatternWithNullInput() {
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskUrlPattern(null, (Pattern)pattern, (String)"***MASKED***", (String)"prefix"));
    }

    @Test
    public void testMaskUrlPatternWithNullPattern() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Assert.assertThrows(NullPointerException.class, () -> CredentialsMaskUtils.maskUrlPattern((String)input, null, (String)"***MASKED***", (String)"prefix"));
    }

    @Test
    public void testMaskUrlPatternWithoutPrefix() {
        String input = "jdbc:mysql://user:pass@localhost:3306/test";
        Pattern pattern = Pattern.compile("jdbc:mysql://([^@]*)@");
        String result = CredentialsMaskUtils.maskUrlPattern((String)input, (Pattern)pattern, (String)"***MASKED***");
        Assert.assertEquals((Object)"jdbc:mysql://***MASKED***@localhost:3306/test", (Object)result);
    }
}

