/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.lang.reflect.Field;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.util.ClassUtils;

public class ClassUtilsTestCase {
    @Test
    public void testGetFieldWithRecursiveTrue() throws NoSuchFieldException {
        Field field = ClassUtils.getField(TestSubClass.class, (String)"testField", (boolean)true);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"testField", (Object)field.getName());
    }

    @Test
    public void testGetFieldWithRecursiveFalse() throws NoSuchFieldException {
        Field field = ClassUtils.getField(TestClass.class, (String)"testField", (boolean)false);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"testField", (Object)field.getName());
    }

    @Test
    public void testGetFieldPublicField() throws NoSuchFieldException {
        Field field = ClassUtils.getField(TestClass.class, (String)"publicField", (boolean)false);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"publicField", (Object)field.getName());
    }

    @Test
    public void testGetFieldSubClassField() throws NoSuchFieldException {
        Field field = ClassUtils.getField(TestSubClass.class, (String)"subClassField", (boolean)false);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"subClassField", (Object)field.getName());
    }

    @Test
    public void testGetFieldNonRecursiveNotFound() {
        Assert.assertThrows(NoSuchFieldException.class, () -> ClassUtils.getField(TestSubClass.class, (String)"testField", (boolean)false));
    }

    @Test
    public void testGetFieldRecursiveNotFound() {
        Assert.assertThrows(NoSuchFieldException.class, () -> ClassUtils.getField(TestClass.class, (String)"nonExistentField", (boolean)true));
    }

    @Test
    public void testGetFieldEmptyClass() {
        Assert.assertThrows(NoSuchFieldException.class, () -> ClassUtils.getField(EmptyClass.class, (String)"anyField", (boolean)true));
    }

    @Test
    public void testGetFieldValue() throws Exception {
        TestClass testObject = new TestClass();
        String value = (String)ClassUtils.getFieldValue((Object)testObject, (String)"testField", (boolean)false);
        Assert.assertEquals((Object)"testValue", (Object)value);
    }

    @Test
    public void testGetFieldValuePublicField() throws Exception {
        TestClass testObject = new TestClass();
        Integer value = (Integer)ClassUtils.getFieldValue((Object)testObject, (String)"publicField", (boolean)false);
        Assert.assertEquals((Object)42, (Object)value);
    }

    @Test
    public void testGetFieldValueRecursive() throws Exception {
        TestSubClass testObject = new TestSubClass();
        String value = (String)ClassUtils.getFieldValue((Object)testObject, (String)"testField", (boolean)true);
        Assert.assertEquals((Object)"testValue", (Object)value);
    }

    @Test
    public void testGetFieldValueSubClassField() throws Exception {
        TestSubClass testObject = new TestSubClass();
        String value = (String)ClassUtils.getFieldValue((Object)testObject, (String)"subClassField", (boolean)false);
        Assert.assertEquals((Object)"subClassValue", (Object)value);
    }

    @Test
    public void testGetFieldValueFieldNotFound() {
        TestClass testObject = new TestClass();
        Assert.assertThrows(NoSuchFieldException.class, () -> ClassUtils.getFieldValue((Object)testObject, (String)"nonExistentField", (boolean)true));
    }

    @Test
    public void testGetFieldValueNullTarget() {
        Assert.assertThrows(NullPointerException.class, () -> ClassUtils.getFieldValue(null, (String)"testField", (boolean)false));
    }

    @Test
    public void testGetFieldValueNullFieldName() {
        TestClass testObject = new TestClass();
        Assert.assertThrows(NullPointerException.class, () -> ClassUtils.getFieldValue((Object)testObject, null, (boolean)false));
    }

    @Test
    public void testGetFieldNullTargetClass() {
        Assert.assertThrows(NullPointerException.class, () -> ClassUtils.getField(null, (String)"testField", (boolean)false));
    }

    @Test
    public void testGetFieldNullFieldName() {
        Assert.assertThrows(NullPointerException.class, () -> ClassUtils.getField(TestClass.class, null, (boolean)false));
    }

    public static class EmptyClass {
    }

    public static class TestSubClass
    extends TestClass {
        private String subClassField = "subClassValue";
    }

    public static class TestClass {
        private String testField = "testValue";
        public int publicField = 42;
    }
}

