/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.util.CaseInsensitiveLinkedMap;

public class CaseInsensitiveLinkedMapTestCase {
    @Test
    public void testDefaultConstructor() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testConstructorWithMap() {
        HashMap<String, String> originalMap = new HashMap<String, String>();
        originalMap.put("Key1", "Value1");
        originalMap.put("Key2", "Value2");
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap(originalMap);
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Value1", (Object)map.get((Object)"Key1"));
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)"Key2"));
    }

    @Test
    public void testPutAndGet() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"TestKey", (Object)"TestValue");
        Assert.assertEquals((Object)"TestValue", (Object)map.get((Object)"TestKey"));
        Assert.assertEquals((Object)"TestValue", (Object)map.get((Object)"testkey"));
        Assert.assertEquals((Object)"TestValue", (Object)map.get((Object)"TESTKEY"));
    }

    @Test
    public void testCaseInsensitiveKeyHandling() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"OriginalKey", (Object)"OriginalValue");
        map.put((Object)"originalkey", (Object)"NewValue");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"NewValue", (Object)map.get((Object)"OriginalKey"));
        Assert.assertEquals((Object)"NewValue", (Object)map.get((Object)"originalkey"));
        Assert.assertEquals((Object)"NewValue", (Object)map.get((Object)"ORIGINALKEY"));
    }

    @Test
    public void testContainsKey() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"TestKey", (Object)"TestValue");
        Assert.assertTrue((boolean)map.containsKey((Object)"TestKey"));
        Assert.assertTrue((boolean)map.containsKey((Object)"testkey"));
        Assert.assertTrue((boolean)map.containsKey((Object)"TESTKEY"));
        Assert.assertFalse((boolean)map.containsKey((Object)"NonExistentKey"));
    }

    @Test
    public void testContainsValue() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Assert.assertTrue((boolean)map.containsValue((Object)"Value1"));
        Assert.assertTrue((boolean)map.containsValue((Object)"Value2"));
        Assert.assertFalse((boolean)map.containsValue((Object)"NonExistentValue"));
    }

    @Test
    public void testRemove() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"TestKey", (Object)"TestValue");
        Assert.assertEquals((Object)"TestValue", (Object)map.remove((Object)"TestKey"));
        Assert.assertNull((Object)map.get((Object)"TestKey"));
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRemoveCaseInsensitive() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"TestKey", (Object)"TestValue");
        Assert.assertEquals((Object)"TestValue", (Object)map.remove((Object)"testkey"));
        Assert.assertNull((Object)map.get((Object)"TestKey"));
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testPutAll() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        HashMap<String, String> otherMap = new HashMap<String, String>();
        otherMap.put("Key1", "Value1");
        otherMap.put("Key2", "Value2");
        map.putAll(otherMap);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Value1", (Object)map.get((Object)"Key1"));
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)"Key2"));
    }

    @Test
    public void testClear() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Assert.assertEquals((long)2L, (long)map.size());
        map.clear();
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testKeySet() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Set keySet = map.keySet();
        Assert.assertEquals((long)2L, (long)keySet.size());
        Assert.assertTrue((boolean)keySet.contains("Key1"));
        Assert.assertTrue((boolean)keySet.contains("Key2"));
    }

    @Test
    public void testValues() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Assert.assertTrue((boolean)map.values().contains("Value1"));
        Assert.assertTrue((boolean)map.values().contains("Value2"));
        Assert.assertEquals((long)2L, (long)map.values().size());
    }

    @Test
    public void testEntrySet() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Assert.assertEquals((long)2L, (long)map.entrySet().size());
        boolean foundKey1 = false;
        boolean foundKey2 = false;
        for (Map.Entry entry : map.entrySet()) {
            if ("Key1".equals(entry.getKey()) && "Value1".equals(entry.getValue())) {
                foundKey1 = true;
            }
            if (!"Key2".equals(entry.getKey()) || !"Value2".equals(entry.getValue())) continue;
            foundKey2 = true;
        }
        Assert.assertTrue((boolean)foundKey1);
        Assert.assertTrue((boolean)foundKey2);
    }

    @Test
    public void testToString() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        String result = map.toString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("Key1"));
        Assert.assertTrue((boolean)result.contains("Value1"));
    }

    @Test
    public void testClone() {
        CaseInsensitiveLinkedMap original = new CaseInsensitiveLinkedMap();
        original.put((Object)"Key1", (Object)"Value1");
        original.put((Object)"Key2", (Object)"Value2");
        try {
            original.clone();
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("CloneNotSupportedException"));
        }
    }

    @Test
    public void testNullKey() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put(null, (Object)"NullKeyValue");
        Assert.assertEquals((Object)"NullKeyValue", (Object)map.get(null));
        Assert.assertTrue((boolean)map.containsKey(null));
        Assert.assertEquals((Object)"NullKeyValue", (Object)map.remove(null));
    }

    @Test
    public void testNullValue() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", null);
        Assert.assertNull((Object)map.get((Object)"Key1"));
        Assert.assertTrue((boolean)map.containsValue(null));
    }

    @Test
    public void testNonStringKeys() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        Integer key1 = 1;
        Double key2 = 2.5;
        map.put((Object)key1, (Object)"Value1");
        map.put((Object)key2, (Object)"Value2");
        Assert.assertEquals((Object)"Value1", (Object)map.get((Object)key1));
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)key2));
        Assert.assertTrue((boolean)map.containsKey((Object)key1));
        Assert.assertTrue((boolean)map.containsKey((Object)key2));
    }

    @Test
    public void testEmptyMapOperations() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)0L, (long)map.size());
        Assert.assertNull((Object)map.get((Object)"AnyKey"));
        Assert.assertFalse((boolean)map.containsKey((Object)"AnyKey"));
        Assert.assertFalse((boolean)map.containsValue((Object)"AnyValue"));
        Assert.assertNull((Object)map.remove((Object)"AnyKey"));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testLargeMapOperations() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        for (int i = 0; i < 100; ++i) {
            map.put((Object)("Key" + i), (Object)("Value" + i));
        }
        Assert.assertEquals((long)100L, (long)map.size());
        Assert.assertEquals((Object)"Value50", (Object)map.get((Object)"key50"));
        Assert.assertEquals((Object)"Value99", (Object)map.get((Object)"KEY99"));
        Assert.assertEquals((Object)"Value25", (Object)map.remove((Object)"key25"));
        Assert.assertEquals((long)99L, (long)map.size());
        Assert.assertFalse((boolean)map.containsKey((Object)"Key25"));
    }

    @Test
    public void testSpecialCharactersInKeys() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key@#$%", (Object)"Value1");
        map.put((Object)"Key^&*()", (Object)"Value2");
        Assert.assertEquals((Object)"Value1", (Object)map.get((Object)"key@#$%"));
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)"KEY^&*()"));
        Assert.assertTrue((boolean)map.containsKey((Object)"KEY@#$%"));
        Assert.assertTrue((boolean)map.containsKey((Object)"key^&*()"));
    }

    @Test
    public void testUnicodeCharactersInKeys() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key\u6d4b\u8bd5", (Object)"Value1");
        map.put((Object)"Key\u03b1\u03b2\u03b3", (Object)"Value2");
        Assert.assertEquals((Object)"Value1", (Object)map.get((Object)"key\u6d4b\u8bd5"));
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)"KEY\u03b1\u03b2\u03b3"));
        Assert.assertTrue((boolean)map.containsKey((Object)"KEY\u6d4b\u8bd5"));
        Assert.assertTrue((boolean)map.containsKey((Object)"key\u03b1\u03b2\u03b3"));
    }

    @Test
    public void testEmptyStringKeys() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"", (Object)"EmptyKeyValue");
        map.put((Object)"  ", (Object)"WhitespaceKeyValue");
        Assert.assertEquals((Object)"EmptyKeyValue", (Object)map.get((Object)""));
        Assert.assertEquals((Object)"WhitespaceKeyValue", (Object)map.get((Object)"  "));
        Assert.assertTrue((boolean)map.containsKey((Object)""));
        Assert.assertTrue((boolean)map.containsKey((Object)"  "));
    }

    @Test
    public void testVeryLongKeys() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        StringBuilder longKey = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            longKey.append("a");
        }
        String key = longKey.toString();
        map.put((Object)key, (Object)"LongKeyValue");
        Assert.assertEquals((Object)"LongKeyValue", (Object)map.get((Object)key));
        Assert.assertEquals((Object)"LongKeyValue", (Object)map.get((Object)key.toUpperCase()));
        Assert.assertTrue((boolean)map.containsKey((Object)key));
        Assert.assertTrue((boolean)map.containsKey((Object)key.toUpperCase()));
    }

    @Test
    public void testMixedCaseOperations() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"MiXeDcAsE", (Object)"Value1");
        map.put((Object)"mixedcase", (Object)"Value2");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)"MiXeDcAsE"));
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)"mixedcase"));
        Assert.assertEquals((Object)"Value2", (Object)map.get((Object)"MIXEDCASE"));
    }

    @Test
    public void testPutAllWithCaseInsensitiveOverlap() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"OriginalValue1");
        map.put((Object)"KEY2", (Object)"OriginalValue2");
        HashMap<String, String> otherMap = new HashMap<String, String>();
        otherMap.put("key1", "NewValue1");
        otherMap.put("Key3", "Value3");
        map.putAll(otherMap);
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"NewValue1", (Object)map.get((Object)"Key1"));
        Assert.assertEquals((Object)"Value3", (Object)map.get((Object)"Key3"));
        Assert.assertEquals((Object)"OriginalValue2", (Object)map.get((Object)"KEY2"));
    }

    @Test
    public void testRemoveNonExistentKey() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        Assert.assertNull((Object)map.remove((Object)"NonExistentKey"));
        Assert.assertEquals((Object)"Value1", (Object)map.remove((Object)"key1"));
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testGetNonExistentKey() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        Assert.assertNull((Object)map.get((Object)"NonExistentKey"));
        Assert.assertNull((Object)map.get((Object)"key2"));
    }

    @Test
    public void testContainsKeyWithNull() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put(null, (Object)"NullValue");
        Assert.assertTrue((boolean)map.containsKey(null));
        Assert.assertFalse((boolean)map.containsKey((Object)"SomeKey"));
    }

    @Test
    public void testContainsValueWithNull() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", null);
        map.put((Object)"Key2", (Object)"Value2");
        Assert.assertTrue((boolean)map.containsValue(null));
        Assert.assertTrue((boolean)map.containsValue((Object)"Value2"));
        Assert.assertFalse((boolean)map.containsValue((Object)"NonExistentValue"));
    }

    @Test
    public void testKeySetModification() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Set keySet = map.keySet();
        Assert.assertEquals((long)2L, (long)keySet.size());
        Assert.assertTrue((boolean)keySet.contains("Key1"));
        Assert.assertTrue((boolean)keySet.contains("Key2"));
        Assert.assertTrue((boolean)keySet.contains("key1"));
    }

    @Test
    public void testValuesModification() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Assert.assertTrue((boolean)map.values().contains("Value1"));
        Assert.assertTrue((boolean)map.values().contains("Value2"));
        Assert.assertEquals((long)2L, (long)map.values().size());
    }

    @Test
    public void testEntrySetModification() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        Set entrySet = map.entrySet();
        Assert.assertEquals((long)2L, (long)entrySet.size());
        boolean foundKey1 = false;
        boolean foundKey2 = false;
        for (Map.Entry entry : entrySet) {
            if ("Key1".equals(entry.getKey()) && "Value1".equals(entry.getValue())) {
                foundKey1 = true;
            }
            if (!"Key2".equals(entry.getKey()) || !"Value2".equals(entry.getValue())) continue;
            foundKey2 = true;
        }
        Assert.assertTrue((boolean)foundKey1);
        Assert.assertTrue((boolean)foundKey2);
    }

    @Test
    public void testToStringWithEmptyMap() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        String result = map.toString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.contains("{}") || result.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToStringWithNullValues() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", null);
        map.put((Object)"Key2", (Object)"Value2");
        String result = map.toString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("Key1"));
        Assert.assertTrue((boolean)result.contains("Key2"));
        Assert.assertTrue((boolean)result.contains("Value2"));
    }

    @Test
    public void testConcurrentModification() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        map.put((Object)"Key1", (Object)"Value1");
        map.put((Object)"Key2", (Object)"Value2");
        try {
            for (String key : map.keySet()) {
                map.put((Object)(key + "Modified"), (Object)"ModifiedValue");
            }
            Assert.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Test
    public void testHashCollisionHandling() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)("Key" + i), (Object)("Value" + i));
        }
        Assert.assertEquals((long)1000L, (long)map.size());
        Assert.assertEquals((Object)"Value0", (Object)map.get((Object)"key0"));
        Assert.assertEquals((Object)"Value500", (Object)map.get((Object)"KEY500"));
        Assert.assertEquals((Object)"Value999", (Object)map.get((Object)"key999"));
    }

    @Test
    public void testObjectKeyToStringConversion() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        Object key1 = new Object(){

            public String toString() {
                return "CustomKey1";
            }
        };
        Object key2 = new Object(){

            public String toString() {
                return "CUSTOMKEY1";
            }
        };
        map.put(key1, (Object)"Value1");
        map.put(key2, (Object)"Value2");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"Value1", (Object)map.get(key1));
        Assert.assertEquals((Object)"Value2", (Object)map.get(key2));
    }

    @Test
    public void testNullKeyToStringConversion() {
        CaseInsensitiveLinkedMap map = new CaseInsensitiveLinkedMap();
        Object nullKey = new Object(){

            public String toString() {
                return null;
            }
        };
        try {
            map.put(nullKey, (Object)"Value1");
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

