/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.DbAggregate;
import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.api.param.OutputParameter;
import org.mule.db.commons.api.param.StatementDefinition;
import org.mule.db.commons.api.param.StoredProcedureCall;
import org.mule.db.commons.api.param.TypeClassifier;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.DefaultInOutQueryParam;
import org.mule.db.commons.internal.domain.param.InputQueryParam;
import org.mule.db.commons.internal.domain.param.OutputQueryParam;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.type.ArrayResolvedDbType;
import org.mule.db.commons.internal.resolver.query.StoredProcedureQueryResolver;
import org.mule.db.commons.utils.MockResultSet;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class StoredProcedureQueryResolverTestCase {
    private static final long CACHE_MAXIMUM_SIZE = 100L;
    private static final short INDEX_COLUMN_FIVE = 5;
    public static final String STORED_PROCEDURE_CALL = "call system.CREATE_RESERVATION(:customerId,:books,:reservationId)";
    public static final int BOOKS_DB_TYPE_ID = 2003;
    public static final String BOOKS_DB_TYPE_NAME = "BOOKS";
    public static final String[] RESERVED_BOOKS = new String[]{"Book1", "Book2"};
    public static final String RESERVATION_ID_PARAM = "reservationId";
    public static final int INTEGER_DB_TYPE_ID = 4;
    public static final String INTEGER_DB_TYPE_NAME = "INTEGER";
    StoredProcedureCall statementDefinition;
    @Mock
    AbstractDbConnector connector;
    @Mock
    DbConnection connection;
    @Mock
    StreamingHelper streamingHelper;
    @Mock
    Connection jdbcConnection;
    @Mock
    DatabaseMetaData metadata;
    ResultSet resultSet;

    @Before
    public void setUp() throws Exception {
        this.statementDefinition = this.createStatementDefinition();
        this.metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)this.metadata.storesUpperCaseIdentifiers()).thenReturn((Object)true);
        this.streamingHelper = (StreamingHelper)Mockito.mock(StreamingHelper.class);
        this.jdbcConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.jdbcConnection.getMetaData()).thenReturn((Object)this.metadata);
        this.connector = (AbstractDbConnector)Mockito.mock(AbstractDbConnector.class);
        this.connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)this.connection.getJdbcConnection()).thenReturn((Object)this.jdbcConnection);
        this.resultSet = this.createResultSet();
        Mockito.when((Object)this.connection.getProcedureColumns((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.resultSet);
        ArrayList<ArrayResolvedDbType> customTypes = new ArrayList<ArrayResolvedDbType>();
        customTypes.add(new ArrayResolvedDbType(2003, BOOKS_DB_TYPE_NAME));
        Mockito.when((Object)this.connection.getCustomDataTypes()).thenReturn(customTypes);
    }

    @Test
    public void when_cacheDoesNotHaveTheQueryTemplate() {
        Cache queryTemplates = Caffeine.newBuilder().maximumSize(100L).recordStats().build();
        Mockito.when((Object)this.connection.getCacheTemplates()).thenReturn((Object)queryTemplates);
        StoredProcedureQueryResolver resolver = new StoredProcedureQueryResolver();
        Assert.assertEquals((long)0L, (long)queryTemplates.stats().hitCount());
        Assert.assertEquals((long)0L, (long)queryTemplates.stats().loadSuccessCount());
        Query query = resolver.resolve((StatementDefinition)this.statementDefinition, this.connector, this.connection, this.streamingHelper);
        Assert.assertEquals((long)0L, (long)queryTemplates.stats().hitCount());
        Assert.assertEquals((long)0L, (long)queryTemplates.stats().hitCount());
        Assert.assertEquals((long)1L, (long)queryTemplates.stats().loadSuccessCount());
        Assert.assertNotNull((Object)queryTemplates.getIfPresent((Object)STORED_PROCEDURE_CALL));
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME.toLowerCase(), (Object)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getName());
        Assert.assertEquals((Object)RESERVED_BOOKS[0], (Object)((DbAggregate)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getValue()).get(0));
        Assert.assertEquals((Object)RESERVED_BOOKS[1], (Object)((DbAggregate)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getValue()).get(1));
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME, (Object)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getType().getName());
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME.toLowerCase(), (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getName());
        Assert.assertEquals((Object)RESERVED_BOOKS[0], (Object)((DbAggregate)((DefaultInOutQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getValue()).get(0));
        Assert.assertEquals((Object)RESERVED_BOOKS[1], (Object)((DbAggregate)((DefaultInOutQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getValue()).get(1));
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME, (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getType().getName());
        Assert.assertEquals((long)2003L, (long)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getType().getId());
        Assert.assertEquals((Object)RESERVATION_ID_PARAM, (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(1)).getName());
        Assert.assertEquals((Object)INTEGER_DB_TYPE_NAME, (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(1)).getType().getName());
        Assert.assertEquals((long)4L, (long)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(1)).getType().getId());
    }

    @Test
    public void when_cacheHasTheQueryTemplate() {
        Cache queryTemplates = Caffeine.newBuilder().maximumSize(100L).recordStats().build();
        Mockito.when((Object)this.connection.getCacheTemplates()).thenReturn((Object)queryTemplates);
        StoredProcedureQueryResolver resolver = new StoredProcedureQueryResolver();
        Assert.assertEquals((long)0L, (long)queryTemplates.stats().hitCount());
        Assert.assertEquals((long)0L, (long)queryTemplates.stats().loadSuccessCount());
        resolver.resolve((StatementDefinition)this.statementDefinition, this.connector, this.connection, this.streamingHelper);
        Assert.assertEquals((long)0L, (long)queryTemplates.stats().hitCount());
        Assert.assertEquals((long)1L, (long)queryTemplates.stats().loadSuccessCount());
        Query query = resolver.resolve((StatementDefinition)this.statementDefinition, this.connector, this.connection, this.streamingHelper);
        Assert.assertEquals((long)1L, (long)queryTemplates.stats().hitCount());
        Assert.assertEquals((long)1L, (long)queryTemplates.stats().loadSuccessCount());
        Assert.assertNotNull((Object)queryTemplates.getIfPresent((Object)STORED_PROCEDURE_CALL));
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME.toLowerCase(), (Object)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getName());
        Assert.assertEquals((Object)RESERVED_BOOKS[0], (Object)((DbAggregate)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getValue()).get(0));
        Assert.assertEquals((Object)RESERVED_BOOKS[1], (Object)((DbAggregate)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getValue()).get(1));
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME, (Object)((InputQueryParam)query.getQueryTemplate().getInputParams().get(1)).getType().getName());
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME.toLowerCase(), (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getName());
        Assert.assertEquals((Object)RESERVED_BOOKS[0], (Object)((DbAggregate)((DefaultInOutQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getValue()).get(0));
        Assert.assertEquals((Object)RESERVED_BOOKS[1], (Object)((DbAggregate)((DefaultInOutQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getValue()).get(1));
        Assert.assertEquals((Object)BOOKS_DB_TYPE_NAME, (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getType().getName());
        Assert.assertEquals((long)2003L, (long)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(0)).getType().getId());
        Assert.assertEquals((Object)RESERVATION_ID_PARAM, (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(1)).getName());
        Assert.assertEquals((Object)INTEGER_DB_TYPE_NAME, (Object)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(1)).getType().getName());
        Assert.assertEquals((long)4L, (long)((OutputQueryParam)query.getQueryTemplate().getOutputParams().get(1)).getType().getId());
    }

    private StoredProcedureCall createStatementDefinition() {
        ArrayList parameterTypes = Lists.newArrayList();
        OutputParameter op1 = new OutputParameter(RESERVATION_ID_PARAM, new TypeClassifier(JdbcType.INTEGER, null));
        ArrayList outputParameterTypes = Lists.newArrayList((Object[])new OutputParameter[]{op1});
        LinkedHashMap<String, Integer> inputParameters = new LinkedHashMap<String, Integer>();
        inputParameters.put("customerId", 1325);
        LinkedHashMap<String, DbAggregate> inoutParameters = new LinkedHashMap<String, DbAggregate>();
        inoutParameters.put(BOOKS_DB_TYPE_NAME.toLowerCase(), new DbAggregate(DbAggregate.Kind.ARRAY, BOOKS_DB_TYPE_NAME, new ArrayList<String>(Arrays.asList(RESERVED_BOOKS))));
        return new StoredProcedureCall(STORED_PROCEDURE_CALL, (List)parameterTypes, inputParameters, inoutParameters, (List)outputParameterTypes, 0, TimeUnit.SECONDS, null, null);
    }

    private MockResultSet createResultSet() {
        ArrayList<Map<Integer, Object>> data = new ArrayList<Map<Integer, Object>>();
        for (int i = 0; i < 3; ++i) {
            HashMap<Integer, Object> columns = new HashMap<Integer, Object>();
            if (i == 0) {
                columns.put(4, "CUSTOMER_ID");
                columns.put(5, (short)5);
                columns.put(6, 2);
                columns.put(7, INTEGER_DB_TYPE_NAME);
            } else if (i == 1) {
                columns.put(4, BOOKS_DB_TYPE_NAME);
                columns.put(5, (short)5);
                columns.put(6, 2);
                columns.put(7, BOOKS_DB_TYPE_NAME);
            } else if (i == 2) {
                columns.put(4, "RESERVATION_ID");
                columns.put(5, (short)5);
                columns.put(6, 2);
                columns.put(7, INTEGER_DB_TYPE_NAME);
            }
            data.add(columns);
        }
        return new MockResultSet(data);
    }
}

