/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.resolver.query.QueryResolutionException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class QueryResolutionExceptionTestCase
extends AbstractMuleTestCase {
    @Test
    public void testConstructorWithMessage() {
        String message = "Test error message";
        QueryResolutionException exception = new QueryResolutionException(message);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)message));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testConstructorWithMessageAndCause() {
        String message = "Test error message";
        RuntimeException cause = new RuntimeException("Original cause");
        QueryResolutionException exception = new QueryResolutionException(message, (Throwable)cause);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)message));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)cause));
    }

    @Test
    public void testConstructorWithNullMessage() {
        QueryResolutionException exception = new QueryResolutionException(null);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)null));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testConstructorWithNullMessageAndCause() {
        RuntimeException cause = new RuntimeException("Original cause");
        QueryResolutionException exception = new QueryResolutionException(null, (Throwable)cause);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)null));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)cause));
    }

    @Test
    public void testConstructorWithMessageAndNullCause() {
        String message = "Test error message";
        QueryResolutionException exception = new QueryResolutionException(message, null);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)message));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testConstructorWithEmptyMessage() {
        String message = "";
        QueryResolutionException exception = new QueryResolutionException(message);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)message));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testClassExtendsRuntimeException() {
        QueryResolutionException exception = new QueryResolutionException("test");
        MatcherAssert.assertThat((Object)(exception instanceof RuntimeException), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        QueryResolutionException exception = new QueryResolutionException("test");
        MatcherAssert.assertThat((Object)exception.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.resolver.query"));
    }

    @Test
    public void testClassHasCorrectName() {
        QueryResolutionException exception = new QueryResolutionException("test");
        MatcherAssert.assertThat((Object)exception.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"QueryResolutionException"));
    }

    @Test
    public void testExceptionCanBeThrown() {
        try {
            throw new QueryResolutionException("Test exception");
        }
        catch (QueryResolutionException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Test exception"));
            return;
        }
    }

    @Test
    public void testExceptionWithCauseCanBeThrown() {
        RuntimeException originalCause = new RuntimeException("Original");
        try {
            throw new QueryResolutionException("Test exception", (Throwable)originalCause);
        }
        catch (QueryResolutionException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Test exception"));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Object)originalCause));
            return;
        }
    }
}

