/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.param;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.resolver.param.DefaultParamTypeResolver;
import org.mule.db.commons.internal.resolver.param.GenericParamTypeResolverFactory;
import org.mule.db.commons.internal.resolver.param.ParamTypeResolver;
import org.mule.db.commons.internal.resolver.param.ParamTypeResolverFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class GenericParamTypeResolverFactoryTestCase {
    @Mock
    private DbTypeManager mockDbTypeManager;
    @Mock
    private QueryTemplate mockQueryTemplate;
    private GenericParamTypeResolverFactory factory;

    @Before
    public void setUp() {
        this.factory = new GenericParamTypeResolverFactory(this.mockDbTypeManager);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.factory);
    }

    @Test
    public void testCreateWithStoredProcedureQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.STORE_PROCEDURE_CALL);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithSelectQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.SELECT);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithInsertQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.INSERT);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithUpdateQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.UPDATE);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithDeleteQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.DELETE);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithMergeQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.MERGE);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithTruncateQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.TRUNCATE);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithDdlQueryTemplate() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.DDL);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateWithNullQueryTemplate() {
        Assert.assertThrows(NullPointerException.class, () -> this.factory.create(null));
    }

    @Test
    public void testCreateWithNullQueryType() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn(null);
        ParamTypeResolver result = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
        ((QueryTemplate)Mockito.verify((Object)this.mockQueryTemplate)).getType();
    }

    @Test
    public void testCreateMultipleInstances() {
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.SELECT);
        ParamTypeResolver result1 = this.factory.create(this.mockQueryTemplate);
        ParamTypeResolver result2 = this.factory.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result1);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result1, (Object)result2);
        Assert.assertTrue((boolean)(result1 instanceof DefaultParamTypeResolver));
        Assert.assertTrue((boolean)(result2 instanceof DefaultParamTypeResolver));
    }

    @Test
    public void testCreateWithDifferentQueryTemplates() {
        QueryTemplate mockQueryTemplate1 = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        QueryTemplate mockQueryTemplate2 = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)mockQueryTemplate1.getType()).thenReturn((Object)QueryType.SELECT);
        Mockito.when((Object)mockQueryTemplate2.getType()).thenReturn((Object)QueryType.STORE_PROCEDURE_CALL);
        ParamTypeResolver result1 = this.factory.create(mockQueryTemplate1);
        ParamTypeResolver result2 = this.factory.create(mockQueryTemplate2);
        Assert.assertNotNull((Object)result1);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result1, (Object)result2);
        Assert.assertTrue((boolean)(result1 instanceof DefaultParamTypeResolver));
        Assert.assertTrue((boolean)(result2 instanceof DefaultParamTypeResolver));
    }

    @Test
    public void testFactoryImplementsParamTypeResolverFactory() {
        Assert.assertTrue((boolean)(this.factory instanceof ParamTypeResolverFactory));
    }

    @Test
    public void testFactoryPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.resolver.param", (Object)GenericParamTypeResolverFactory.class.getPackage().getName());
    }

    @Test
    public void testFactoryClassName() {
        Assert.assertEquals((Object)"GenericParamTypeResolverFactory", (Object)GenericParamTypeResolverFactory.class.getSimpleName());
    }

    @Test
    public void testFactoryFullClassName() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.resolver.param.GenericParamTypeResolverFactory", (Object)GenericParamTypeResolverFactory.class.getName());
    }

    @Test
    public void testCreateWithNullDbTypeManager() {
        GenericParamTypeResolverFactory factoryWithNullManager = new GenericParamTypeResolverFactory(null);
        Mockito.when((Object)this.mockQueryTemplate.getType()).thenReturn((Object)QueryType.SELECT);
        ParamTypeResolver result = factoryWithNullManager.create(this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DefaultParamTypeResolver));
    }
}

