/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.param;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.DefaultInOutQueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.resolver.param.DefaultParamTypeResolver;
import org.mule.db.commons.internal.resolver.param.ParamTypeResolver;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultParamTypeResolverTestCase {
    @Mock
    private DbTypeManager dbTypeManager;
    @Mock
    private ParamTypeResolver metadataParamTypeResolver;
    @Mock
    private DbConnection dbConnection;

    @Test
    public void testGetParameterTypesFallsBackEnableOnBadSqlSyntaxException() throws Exception {
        System.setProperty("mule.db.commons.defaultParamTypeResolver.enable.fallback", "true");
        DefaultParamTypeResolver resolver = new DefaultParamTypeResolver(this.dbTypeManager, this.metadataParamTypeResolver);
        DefaultInOutQueryParam unknowParam = new DefaultInOutQueryParam(1, UnknownDbType.getInstance(), "aParam", null);
        List<DefaultInOutQueryParam> params = Collections.singletonList(unknowParam);
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getParams()).thenReturn(params);
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes((DbConnection)ArgumentMatchers.any(), (QueryTemplate)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenThrow(new Throwable[]{new BadSqlSyntaxException("BadSqlSyntaxException")});
        Map result = resolver.getParameterTypes(this.dbConnection, queryTemplate, Collections.emptyList());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)unknowParam.getType(), result.get(1));
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testGetParameterTypesFallsBackDisableOnBadSqlSyntaxException() throws Exception {
        DefaultParamTypeResolver resolver = new DefaultParamTypeResolver(this.dbTypeManager, this.metadataParamTypeResolver);
        DefaultInOutQueryParam unknowParam = new DefaultInOutQueryParam(1, UnknownDbType.getInstance(), "aParam", null);
        List<DefaultInOutQueryParam> params = Collections.singletonList(unknowParam);
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getParams()).thenReturn(params);
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes((DbConnection)ArgumentMatchers.any(), (QueryTemplate)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenThrow(new Throwable[]{new BadSqlSyntaxException("BadSqlSyntaxException")});
        resolver.getParameterTypes(this.dbConnection, queryTemplate, Collections.emptyList());
    }

    @Test
    public void testGetParameterTypesFallsBackDisableSqlException() throws Exception {
        DefaultParamTypeResolver resolver = new DefaultParamTypeResolver(this.dbTypeManager, this.metadataParamTypeResolver);
        DefaultInOutQueryParam unknowParam = new DefaultInOutQueryParam(1, UnknownDbType.getInstance(), "aParam", null);
        List<DefaultInOutQueryParam> params = Collections.singletonList(unknowParam);
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getParams()).thenReturn(params);
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes((DbConnection)ArgumentMatchers.any(), (QueryTemplate)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SQLException("SQLException")});
        Map result = resolver.getParameterTypes(this.dbConnection, queryTemplate, Collections.emptyList());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)unknowParam.getType(), result.get(1));
    }

    @Test
    public void testGetParameterTypesFallsBackEnableSqlException() throws Exception {
        System.setProperty("mule.db.commons.defaultParamTypeResolver.enable.fallback", "true");
        DefaultParamTypeResolver resolver = new DefaultParamTypeResolver(this.dbTypeManager, this.metadataParamTypeResolver);
        DefaultInOutQueryParam unknowParam = new DefaultInOutQueryParam(1, UnknownDbType.getInstance(), "aParam", null);
        List<DefaultInOutQueryParam> params = Collections.singletonList(unknowParam);
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getParams()).thenReturn(params);
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes((DbConnection)ArgumentMatchers.any(), (QueryTemplate)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenThrow(new Throwable[]{new SQLException("SQLException")});
        Map result = resolver.getParameterTypes(this.dbConnection, queryTemplate, Collections.emptyList());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)unknowParam.getType(), result.get(1));
    }
}

