/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.UpdateStatementTypeDetector;

public class UpdateStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        UpdateStatementTypeDetector detector = new UpdateStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.UPDATE));
    }

    @Test
    public void validUpdateStatementTest() {
        UpdateStatementTypeDetector detector = new UpdateStatementTypeDetector();
        List<String> truncateStatements = Arrays.asList("update pepe set name ='nicolas' where id=434;", "UPDATE  MYTABLE SET STREET='WALL ST' where id=2", "Update someTable set color='RED' where color is 'WHITE'");
        for (String statement : truncateStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidUpdateStatementTest() {
        UpdateStatementTypeDetector detector = new UpdateStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("SELECT * FROM MY TABLE;", "MERGE FROM MYTABLE", "Insert into my table", "Truncate TAble MyTable");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

