/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.AbstractStatementTypeDetector;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractStatementTypeDetectorTestCase {
    private TestStatementTypeDetector detector;

    @Before
    public void setUp() {
        this.detector = new TestStatementTypeDetector();
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)((Object)this.detector));
        Assert.assertEquals((Object)QueryType.SELECT, (Object)this.detector.getType());
        Assert.assertEquals((Object)"(?ms)TEST\\s++.+", (Object)this.detector.DETECTION_REGEX);
    }

    @Test
    public void testIsOfTypeWithMatchingSQL() {
        String sql = "TEST * FROM users";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithNonMatchingSQL() {
        String sql = "SELECT * FROM users";
        boolean result = this.detector.isOfType(sql);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testIsOfTypeWithCaseInsensitiveMatching() {
        String sql = "test * FROM users";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithMixedCase() {
        String sql = "TeSt * FROM users";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithWhitespace() {
        String sql = "  TEST  *  FROM  users  ";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithNewlines() {
        String sql = "TEST\n* FROM\nusers";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithTabs() {
        String sql = "TEST\t* FROM\tusers";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithComplexSQL() {
        String sql = "TEST u.name, t.data FROM temp t JOIN users u ON t.id = u.id WHERE u.active = true";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithSubquery() {
        String sql = "TEST * FROM users WHERE id IN (SELECT user_id FROM orders)";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithUnion() {
        String sql = "TEST * FROM users UNION TEST * FROM users_backup";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsOfTypeWithCaseStatement() {
        String sql = "TEST CASE WHEN id = 1 THEN 'one' ELSE 'other' END FROM users";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=NullPointerException.class)
    public void testIsOfTypeWithNullSQL() {
        this.detector.isOfType(null);
    }

    @Test
    public void testIsOfTypeWithEmptySQL() {
        String sql = "";
        boolean result = this.detector.isOfType(sql);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testIsOfTypeWithWhitespaceOnlySQL() {
        String sql = "   ";
        boolean result = this.detector.isOfType(sql);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testIsOfTypeWithPartialMatch() {
        String sql = "TEST";
        boolean result = this.detector.isOfType(sql);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testIsOfTypeWithExactMatch() {
        String sql = "TEST * FROM users";
        boolean result = this.detector.isOfType(sql);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testGetType() {
        QueryType result = this.detector.getType();
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result);
    }

    @Test
    public void testCleanupWithNormalSQL() {
        String sql = "  test  *  from  users  ";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST  *  FROM  USERS", (Object)result);
    }

    @Test
    public void testCleanupWithMixedCase() {
        String sql = "TeSt * FrOm UsErS";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST * FROM USERS", (Object)result);
    }

    @Test
    public void testCleanupWithNewlines() {
        String sql = "test\n* from\nusers";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST\n* FROM\nUSERS", (Object)result);
    }

    @Test
    public void testCleanupWithTabs() {
        String sql = "test\t* from\tusers";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST\t* FROM\tUSERS", (Object)result);
    }

    @Test
    public void testCleanupWithSpecialCharacters() {
        String sql = "test * from users where name = 'john's data'";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST * FROM USERS WHERE NAME = 'JOHN'S DATA'", (Object)result);
    }

    @Test
    public void testCleanupWithUnicodeCharacters() {
        String sql = "test * from users where name = 'Jos\u00e9 Mar\u00eda'";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST * FROM USERS WHERE NAME = 'JOS\u00c9 MAR\u00cdA'", (Object)result);
    }

    @Test
    public void testCleanupWithNumbers() {
        String sql = "test * from users where id = 123";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST * FROM USERS WHERE ID = 123", (Object)result);
    }

    @Test
    public void testCleanupWithSymbols() {
        String sql = "test * from users where id > 10 and id < 100";
        String result = this.detector.cleanup(sql);
        Assert.assertEquals((Object)"TEST * FROM USERS WHERE ID > 10 AND ID < 100", (Object)result);
    }

    @Test
    public void testMultipleDetectors() {
        TestStatementTypeDetector detector1 = new TestStatementTypeDetector();
        TestStatementTypeDetector detector2 = new TestStatementTypeDetector();
        String sql = "TEST * FROM users";
        boolean result1 = detector1.isOfType(sql);
        boolean result2 = detector2.isOfType(sql);
        Assert.assertTrue((boolean)result1);
        Assert.assertTrue((boolean)result2);
        Assert.assertEquals((Object)detector1.getType(), (Object)detector2.getType());
    }

    @Test
    public void testDetectorWithDifferentQueryType() {
        TestInsertDetector insertDetector = new TestInsertDetector();
        String sql = "INSERT INTO users VALUES (1, 'John')";
        boolean result = insertDetector.isOfType(sql);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)QueryType.INSERT, (Object)insertDetector.getType());
    }

    private static class TestInsertDetector
    extends AbstractStatementTypeDetector {
        private static final String INSERT_REGEX = String.format("(?ms)%s\\s++.+", "INSERT");

        public TestInsertDetector() {
            super(QueryType.INSERT, INSERT_REGEX);
        }
    }

    private static class TestStatementTypeDetector
    extends AbstractStatementTypeDetector {
        private static final String TEST_REGEX = String.format("(?ms)%s\\s++.+", "TEST");

        public TestStatementTypeDetector() {
            super(QueryType.SELECT, TEST_REGEX);
        }
    }
}

