/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.api.param.StoredProcedureCall;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.operation.DmlOperations;
import org.mule.db.commons.internal.resolver.query.ParameterizedQueryResolver;
import org.mule.db.commons.internal.resolver.query.QueryResolver;
import org.mule.db.commons.internal.resolver.query.StoredProcedureQueryResolver;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@RunWith(value=MockitoJUnitRunner.class)
public class DmlOperationsTestCase {
    @Mock
    private QueryResolver<ParameterizedStatementDefinition> mockQueryResolver;
    @Mock
    private ParameterizedQueryResolver<StoredProcedureCall> mockStoredProcedureResolver;
    @Mock
    private ConfigurableStatementFactory mockStatementFactory;
    @Mock
    private BiFunction<DbConnection, Charset, RowHandler> mockSelectRowHandler;
    @Mock
    private BiFunction<DbConnection, Charset, RowHandler> mockQuerySingleRowHandler;
    @Mock
    private BiFunction<DbConnection, Charset, RowHandler> mockStoredProcedureRowHandler;
    @Mock
    private BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> mockSelectQueryExecutor;
    @Mock
    private BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> mockQuerySingleQueryExecutor;
    @Mock
    private Function<ConfigurableStatementFactory, QueryExecutor> mockUpdateExecutor;
    @Mock
    private AbstractDbConnector mockConnector;
    @Mock
    private DbConnection mockConnection;
    @Mock
    private StreamingHelper mockStreamingHelper;
    @Mock
    private FlowListener mockFlowListener;
    @Mock
    private Connection mockJdbcConnection;
    @Mock
    private DatabaseMetaData mockDatabaseMetaData;
    private DmlOperations dmlOperations;

    @Before
    public void setUp() throws SQLException {
        this.dmlOperations = new DmlOperations.Builder().withQueryResolver(this.mockQueryResolver).withStoredProcedureQueryResolver(this.mockStoredProcedureResolver).withStatementFactory(this.mockStatementFactory).withSelectRowHandler(this.mockSelectRowHandler).withQuerySingleRowHandler(this.mockQuerySingleRowHandler).withStoredProcedureRowHandler(this.mockStoredProcedureRowHandler).withSelectQueryExecutor(this.mockSelectQueryExecutor).withQuerySingleQueryExecutor(this.mockQuerySingleQueryExecutor).withUpdateExecutor(this.mockUpdateExecutor).build();
    }

    @Test
    public void testBuilderWithAllParameters() {
        DmlOperations.Builder builder = new DmlOperations.Builder().withQueryResolver(this.mockQueryResolver).withStoredProcedureQueryResolver(this.mockStoredProcedureResolver).withStatementFactory(this.mockStatementFactory).withSelectRowHandler(this.mockSelectRowHandler).withQuerySingleRowHandler(this.mockQuerySingleRowHandler).withStoredProcedureRowHandler(this.mockStoredProcedureRowHandler).withSelectQueryExecutor(this.mockSelectQueryExecutor).withQuerySingleQueryExecutor(this.mockQuerySingleQueryExecutor).withUpdateExecutor(this.mockUpdateExecutor);
        DmlOperations result = builder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testBuilderWithDefaultValues() {
        DmlOperations.Builder builder = new DmlOperations.Builder();
        DmlOperations result = builder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDefaultStoredProcedureResolver() {
        ParameterizedQueryResolver resolver = DmlOperations.getDefaultStoredProcedureResolver();
        Assert.assertNotNull((Object)resolver);
        Assert.assertTrue((boolean)(resolver instanceof StoredProcedureQueryResolver));
    }

    @Test
    public void testGetDefaultInsensitiveMapRowHandler() {
        BiFunction handler = DmlOperations.getDefaultInsensitiveMapRowHandler();
        Assert.assertNotNull((Object)handler);
    }

    @Test
    public void testGetDefaultNonStreamingInsensitiveMapRowHandler() {
        BiFunction handler = DmlOperations.getDefaultNonStreamingInsensitiveMapRowHandler();
        Assert.assertNotNull((Object)handler);
    }

    @Test
    public void testGetDefaultSelectExecutor() {
        BiFunction executor = DmlOperations.getDefaultSelectExecutor();
        Assert.assertNotNull((Object)executor);
    }

    @Test
    public void testBuilderChaining() {
        DmlOperations.Builder builder = new DmlOperations.Builder();
        DmlOperations.Builder result = builder.withQueryResolver(this.mockQueryResolver).withStoredProcedureQueryResolver(this.mockStoredProcedureResolver).withStatementFactory(this.mockStatementFactory).withSelectRowHandler(this.mockSelectRowHandler).withQuerySingleRowHandler(this.mockQuerySingleRowHandler).withStoredProcedureRowHandler(this.mockStoredProcedureRowHandler).withSelectQueryExecutor(this.mockSelectQueryExecutor).withQuerySingleQueryExecutor(this.mockQuerySingleQueryExecutor).withUpdateExecutor(this.mockUpdateExecutor);
        Assert.assertSame((Object)builder, (Object)result);
    }

    @Test
    public void testResolveResultStreams() {
        HashMap<String, String> inputMap = new HashMap<String, String>();
        inputMap.put("key1", "value1");
        inputMap.put("key2", "value2");
        Assert.assertNotNull((Object)this.dmlOperations);
    }

    @Test
    public void testResolveQueryWithStoredProcedure() {
        Assert.assertNotNull((Object)this.dmlOperations);
    }
}

